/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.ContentsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsLogContentUtil {
    private static final Logger LOG = Logger.getInstance(VcsLogContentUtil.class);

    public static <U extends AbstractVcsLogUi> boolean findAndSelectContent(@NotNull Project project2, @NotNull Class<U> clazz, @NotNull Condition<U> condition2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentUtil", "findAndSelectContent"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/vcs/log/impl/VcsLogContentUtil", "findAndSelectContent"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/impl/VcsLogContentUtil", "findAndSelectContent"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        ContentManager manager = toolWindow.getContentManager();
        JComponent component = ContentUtilEx.findContentComponent(manager, (Condition<JComponent>)((Condition)c -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/vcs/log/impl/VcsLogContentUtil", "lambda$findAndSelectContent$0"));
            }
            if (condition2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/impl/VcsLogContentUtil", "lambda$findAndSelectContent$0"));
            }
            VcsLogPanel vcsLogPanel = null;
            if (c instanceof VcsLogPanel) {
                vcsLogPanel = (VcsLogPanel)((Object)((Object)c));
            } else if (c instanceof JPanel) {
                vcsLogPanel = (VcsLogPanel)((Object)((Object)ContainerUtil.findInstance((Object[])c.getComponents(), VcsLogPanel.class)));
            }
            if (vcsLogPanel != null) {
                AbstractVcsLogUi ui = vcsLogPanel.getUi();
                return clazz.isInstance(ui) && condition2.value((Object)ui);
            }
            return false;
        }));
        if (component == null) {
            return false;
        }
        if (!toolWindow.isVisible()) {
            toolWindow.activate(null);
        }
        return ContentUtilEx.selectContent(manager, component, true);
    }

    public static boolean selectLogUi(@NotNull Project project2, @NotNull VcsLogUi ui) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentUtil", "selectLogUi"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogContentUtil", "selectLogUi"));
        }
        return VcsLogContentUtil.findAndSelectContent(project2, AbstractVcsLogUi.class, u -> {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogContentUtil", "lambda$selectLogUi$1"));
            }
            return u.equals(ui);
        });
    }

    public static void openAnotherLogTab(@NotNull VcsLogManager logManager, @NotNull Project project2) {
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openAnotherLogTab"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openAnotherLogTab"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name2 = VcsLogContentUtil.generateShortName(toolWindow);
        VcsLogContentUtil.openLogTab(project2, logManager, "Log", name2, logManager.getMainLogUiFactory(name2));
    }

    @NotNull
    private static String generateShortName(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/vcs/log/impl/VcsLogContentUtil", "generateShortName"));
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(toolWindow.getContentManager(), "Log");
        if (tabbedContent != null) {
            String string = String.valueOf(tabbedContent.getTabs().size() + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentUtil", "generateShortName"));
            }
            return string;
        }
        List contents = ContainerUtil.filter((Object[])toolWindow.getContentManager().getContents(), content -> "Log".equals(content.getUserData(Content.TAB_GROUP_NAME_KEY)));
        String string = String.valueOf(contents.size() + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentUtil", "generateShortName"));
        }
        return string;
    }

    public static <U extends AbstractVcsLogUi> void openLogTab(@NotNull Project project2, @NotNull VcsLogManager logManager, @NotNull String tabGroupName, @NotNull String shortName, @NotNull VcsLogManager.VcsLogUiFactory<U> factory) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openLogTab"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openLogTab"));
        }
        if (tabGroupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabGroupName", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openLogTab"));
        }
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openLogTab"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openLogTab"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.VCS);
        String name2 = ContentUtilEx.getFullName(tabGroupName, shortName);
        U logUi = logManager.createLogUi(name2, factory);
        ContentUtilEx.addTabbedContent(toolWindow.getContentManager(), (JComponent)((Object)new VcsLogPanel(logManager, (AbstractVcsLogUi)logUi)), tabGroupName, shortName, true, logUi);
        toolWindow.activate(null);
        logManager.scheduleInitialization();
    }

    public static void openMainLogAndExecute(@NotNull Project project2, @NotNull Consumer<VcsLogUiImpl> consumer) {
        VcsLogUiImpl logUi;
        Content[] contents;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openMainLogAndExecute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogContentUtil", "openMainLogAndExecute"));
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        boolean logReady = projectLog.getMainLogUi() != null;
        ToolWindow window = ToolWindowManager.getInstance((Project)project2).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            break;
        }
        if ((logUi = projectLog.getMainLogUi()) == null) {
            VcsBalloonProblemNotifier.showOverChangesView(project2, "Vcs Log Not Ready", MessageType.WARNING, new NamedRunnable[0]);
            return;
        }
        Runnable openLogAndRun = () -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogContentUtil", "lambda$openMainLogAndExecute$4"));
            }
            if (!window.isVisible()) {
                window.activate(() -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogContentUtil", "lambda$null$3"));
                    }
                    consumer.consume((Object)logUi);
                }, true);
            } else {
                consumer.consume((Object)logUi);
            }
        };
        if (logReady) {
            openLogAndRun.run();
            return;
        }
        logUi.invokeOnChange(openLogAndRun);
    }

    public static void closeLogTabs(@NotNull ToolWindow toolWindow, @NotNull Collection<String> tabs) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/vcs/log/impl/VcsLogContentUtil", "closeLogTabs"));
        }
        if (tabs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabs", "com/intellij/vcs/log/impl/VcsLogContentUtil", "closeLogTabs"));
        }
        for (String tabName : tabs) {
            Content content = toolWindow.getContentManager().findContent(tabName);
            LOG.assertTrue(content != null, (Object)("Could not find content for tab " + tabName));
            if (!content.isCloseable()) continue;
            ContentsUtil.closeContentTab((ContentManager)toolWindow.getContentManager(), (Content)content);
        }
    }
}

