/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final AbstractVcsLogUi myUi;

    public VcsLogImpl(@NotNull VcsLogData manager, @NotNull AbstractVcsLogUi ui) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        this.myLogData = manager;
        this.myUi = ui;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        List<CommitId> list2 = this.getSelectedDataFromTable(GraphTableModel::getCommitIdAtRow);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedCommits"));
        }
        return list2;
    }

    @NotNull
    public List<VcsShortCommitDetails> getSelectedShortDetails() {
        List<VcsShortCommitDetails> list2 = this.getSelectedDataFromTable(GraphTableModel::getShortDetails);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedShortDetails"));
        }
        return list2;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        List<VcsFullCommitDetails> list2 = this.getSelectedDataFromTable(GraphTableModel::getFullDetails);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDetails"));
        }
        return list2;
    }

    public void requestSelectedDetails(@NotNull Consumer<List<VcsFullCommitDetails>> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogImpl", "requestSelectedDetails"));
        }
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.getTable().getModel().convertToCommitIds(rowsList), (Consumer)consumer, (ProgressIndicator)null);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesQuickly(root, commitHash);
    }

    @NotNull
    public Future<Boolean> jumpToReference(String reference) {
        SettableFuture future2 = SettableFuture.create();
        VcsLogRefs refs = this.myUi.getDataPack().getRefs();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List matchingRefs = refs.stream().filter(ref -> ref.getName().startsWith(reference)).collect(Collectors.toList());
            ApplicationManager.getApplication().invokeLater(() -> {
                if (matchingRefs.isEmpty()) {
                    this.myUi.jumpToCommitByPartOfHash(reference, (SettableFuture<Boolean>)future2);
                } else {
                    VcsRef ref = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
                    this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot(), (SettableFuture<Boolean>)future2);
                }
            });
        });
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "jumpToReference"));
        }
        return settableFuture;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myLogData.getLogProviders();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getLogProviders"));
        }
        return map2;
    }

    @NotNull
    private VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myUi.getTable();
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getTable"));
        }
        return vcsLogGraphTable;
    }

    @NotNull
    private <T> List<T> getSelectedDataFromTable(final @NotNull BiFunction<GraphTableModel, Integer, T> dataGetter) {
        if (dataGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGetter", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDataFromTable"));
        }
        final int[] rows = this.myUi.getTable().getSelectedRows();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            @NotNull
            public T get(int index) {
                Object r = dataGetter.apply(VcsLogImpl.this.getTable().getModel(), rows[index]);
                if (r == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl$1", "get"));
                }
                return r;
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDataFromTable"));
        }
        return abstractList;
    }
}

