/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogTabsWatcher
implements Disposable {
    private static final String TOOLWINDOW_ID = ChangesViewContentManager.TOOLWINDOW_ID;
    @NotNull
    private final PostponableLogRefresher myRefresher;
    @NotNull
    private final ToolWindowManagerEx myToolWindowManager;
    @NotNull
    private final MyRefreshPostponedEventsListener myPostponedEventsListener;
    @Nullable
    private ToolWindow myToolWindow;

    public VcsLogTabsWatcher(@NotNull Project project2, @NotNull PostponableLogRefresher refresher) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogTabsWatcher", "<init>"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/impl/VcsLogTabsWatcher", "<init>"));
        }
        this.myRefresher = refresher;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx(project2);
        this.myPostponedEventsListener = new MyRefreshPostponedEventsListener();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myToolWindowManager.addToolWindowManagerListener(this.myPostponedEventsListener);
            this.installContentListener();
        });
    }

    @Nullable
    private String getSelectedTabName() {
        Content content;
        if (this.myToolWindow != null && this.myToolWindow.isVisible() && (content = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            return content.getTabName();
        }
        return null;
    }

    @NotNull
    public Disposable addTabToWatch(@NotNull String contentTabName, @NotNull VisiblePackRefresher refresher) {
        if (contentTabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTabName", "com/intellij/vcs/log/impl/VcsLogTabsWatcher", "addTabToWatch"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/impl/VcsLogTabsWatcher", "addTabToWatch"));
        }
        Disposable disposable = this.myRefresher.addLogWindow(new VcsLogTab(refresher, contentTabName));
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogTabsWatcher", "addTabToWatch"));
        }
        return disposable;
    }

    private void installContentListener() {
        ToolWindow window = this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (window != null) {
            this.myToolWindow = window;
            this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
        }
    }

    private void removeListeners() {
        this.myToolWindowManager.removeToolWindowManagerListener(this.myPostponedEventsListener);
        if (this.myToolWindow != null) {
            this.myToolWindow.getContentManager().removeContentManagerListener((ContentManagerListener)this.myPostponedEventsListener);
            for (Content content : this.myToolWindow.getContentManager().getContents()) {
                if (!(content instanceof TabbedContent)) continue;
                content.removePropertyChangeListener((PropertyChangeListener)this.myPostponedEventsListener);
            }
        }
    }

    public void closeLogTabs() {
        if (this.myToolWindow != null) {
            VcsLogContentUtil.closeLogTabs(this.myToolWindow, StreamEx.of(this.myRefresher.getLogWindows()).select(VcsLogTab.class).map(VcsLogTab::getTabName).toSet());
        }
    }

    public void dispose() {
        this.removeListeners();
    }

    private class MyRefreshPostponedEventsListener
    extends ContentManagerAdapter
    implements ToolWindowManagerListener,
    PropertyChangeListener {
        private MyRefreshPostponedEventsListener() {
        }

        private void selectionChanged() {
            String tabName = VcsLogTabsWatcher.this.getSelectedTabName();
            if (tabName != null) {
                this.selectionChanged(tabName);
            }
        }

        private void selectionChanged(String tabName) {
            PostponableLogRefresher.VcsLogWindow logWindow = (PostponableLogRefresher.VcsLogWindow)ContainerUtil.find(VcsLogTabsWatcher.this.myRefresher.getLogWindows(), window -> window instanceof VcsLogTab && ((VcsLogTab)window).myTabName.equals(tabName));
            if (logWindow != null) {
                VcsLogTabsWatcher.this.myRefresher.filtererActivated(logWindow.getRefresher(), false);
            }
        }

        public void selectionChanged(ContentManagerEvent event) {
            if (ContentManagerEvent.ContentOperation.add.equals((Object)event.getOperation())) {
                this.selectionChanged(event.getContent().getTabName());
            }
        }

        public void contentAdded(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content instanceof TabbedContent) {
                content.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void stateChanged() {
            if (VcsLogTabsWatcher.this.myToolWindow == null) {
                return;
            }
            if (VcsLogTabsWatcher.this.myToolWindowManager.getToolWindow(TOOLWINDOW_ID) == null) {
                VcsLogTabsWatcher.this.removeListeners();
            } else {
                this.selectionChanged();
            }
        }

        @Override
        public void toolWindowRegistered(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$MyRefreshPostponedEventsListener", "toolWindowRegistered"));
            }
            if (id.equals(TOOLWINDOW_ID)) {
                VcsLogTabsWatcher.this.installContentListener();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("component")) {
                this.selectionChanged();
            }
        }
    }

    public class VcsLogTab
    extends PostponableLogRefresher.VcsLogWindow {
        @NotNull
        private final String myTabName;

        public VcsLogTab(@NotNull VisiblePackRefresher refresher, String tabName) {
            if (refresher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab", "<init>"));
            }
            if (tabName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab", "<init>"));
            }
            super(refresher);
            this.myTabName = tabName;
        }

        @Override
        public boolean isVisible() {
            String selectedTab = VcsLogTabsWatcher.this.getSelectedTabName();
            return selectedTab != null && this.myTabName.equals(selectedTab);
        }

        @NotNull
        public String getTabName() {
            String string = this.myTabName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogTabsWatcher$VcsLogTab", "getTabName"));
            }
            return string;
        }
    }
}

