/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

abstract class CollapseOrExpandGraphAction
extends DumbAwareAction {
    private static final String LINEAR_BRANCHES = "Linear Branches";
    private static final String LINEAR_BRANCHES_DESCRIPTION = "linear branches";
    private static final String MERGES = "Merges";
    private static final String MERGES_DESCRIPTION = "merges";

    public CollapseOrExpandGraphAction(@NotNull String action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction", "<init>"));
        }
        super(action + " " + LINEAR_BRANCHES, action + " " + LINEAR_BRANCHES_DESCRIPTION, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction", "actionPerformed"));
        }
        VcsLogUtil.triggerUsage(e);
        VcsLogUi ui = (VcsLogUi)e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        this.executeAction((VcsLogUiImpl)ui);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction", "update"));
        }
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogUiProperties properties = (VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES);
        if (ui != null && ui.areGraphActionsEnabled() && properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE)) {
            e.getPresentation().setEnabled(true);
            if (!ui.getFilterUi().getFilters().getDetailsFilters().isEmpty()) {
                e.getPresentation().setEnabled(false);
            }
            if (properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek) {
                e.getPresentation().setText(this.getPrefix() + MERGES);
                e.getPresentation().setDescription(this.getPrefix() + MERGES_DESCRIPTION);
            } else {
                e.getPresentation().setText(this.getPrefix() + LINEAR_BRANCHES);
                e.getPresentation().setDescription(this.getPrefix() + LINEAR_BRANCHES_DESCRIPTION);
            }
        } else {
            e.getPresentation().setEnabled(false);
        }
        e.getPresentation().setText(this.getPrefix() + LINEAR_BRANCHES);
        e.getPresentation().setDescription(this.getPrefix() + LINEAR_BRANCHES_DESCRIPTION);
        if (CollapseOrExpandGraphAction.isIconHidden(e)) {
            e.getPresentation().setIcon(null);
        } else {
            e.getPresentation().setIcon(properties != null && properties.exists(MainVcsLogUiProperties.BEK_SORT_TYPE) && properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? this.getMergesIcon() : this.getBranchesIcon());
        }
    }

    protected abstract void executeAction(@NotNull VcsLogUiImpl var1);

    @NotNull
    protected abstract Icon getMergesIcon();

    @NotNull
    protected abstract Icon getBranchesIcon();

    @NotNull
    protected abstract String getPrefix();

    private static boolean isIconHidden(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/CollapseOrExpandGraphAction", "isIconHidden"));
        }
        return e.getPlace().equals("ToolwindowPopup");
    }
}

