/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromHistoryActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider", "isActive"));
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider", "update"));
        }
        Project project2 = e.getProject();
        FileHistoryUi ui = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (project2 == null || ui == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List selectedCommits = ui.getVcsLog().getSelectedCommits();
        String commitMessage = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        e.getPresentation().setEnabled(!selectedCommits.isEmpty() && commitMessage != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider", "actionPerformed"));
        }
        VcsLogUtil.triggerUsage(e);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileHistoryUi ui = (FileHistoryUi)e.getRequiredData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        String commitMessage = (String)e.getRequiredData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        ui.getVcsLog().requestSelectedDetails(detailsList -> {
            List<Change> changes = ui.collectChanges((List<VcsFullCommitDetails>)detailsList, false);
            CreatePatchFromChangesAction.createPatch(project2, commitMessage, changes);
        });
    }
}

