/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.history.actions.GetVersionAction;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.ui.actions.history.FileHistorySingleCommitAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GetVersionFromHistoryAction
extends FileHistorySingleCommitAction {
    @Override
    protected boolean isEnabled(@NotNull FileHistoryUi ui, @Nullable VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        VcsFileRevision fileRevision;
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "isEnabled"));
        }
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null || filePath.isDirectory()) {
            return false;
        }
        return detail == null || !VcsHistoryUtil.isEmpty(fileRevision = ui.createRevision(detail));
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull FileHistoryUi ui, @NotNull VcsFullCommitDetails detail, @NotNull AnActionEvent e) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "performAction"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "performAction"));
        }
        if (detail == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detail", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "performAction"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/actions/history/GetVersionFromHistoryAction", "performAction"));
        }
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        VcsFileRevision revision = ui.createRevision(detail);
        if (!VcsHistoryUtil.isEmpty(revision)) {
            GetVersionAction.doGet(project2, revision, (FilePath)e.getRequiredData(VcsDataKeys.FILE_PATH));
        }
    }
}

