/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.google.common.primitives.Chars;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.textCompletion.ValuesCompletionProvider;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultilinePopupBuilder {
    private static final char[] SEPARATORS = new char[]{'|', '\n'};
    @NotNull
    private final EditorTextField myTextField;

    MultilinePopupBuilder(@NotNull Project project2, @NotNull Collection<String> values, @NotNull String initialValue, boolean supportsNegativeValues) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "<init>"));
        }
        this.myTextField = MultilinePopupBuilder.createTextField(project2, values, supportsNegativeValues, initialValue);
    }

    @NotNull
    private static EditorTextField createTextField(@NotNull Project project2, Collection<String> values, boolean supportsNegativeValues, @NotNull String initialValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        if (initialValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialValue", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        TextFieldWithCompletion textField = new TextFieldWithCompletion(project2, new MyCompletionProvider(values, supportsNegativeValues), initialValue, false, true, false){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                SoftWrapsEditorCustomization.ENABLED.customize(editor);
                return editor;
            }
        };
        textField.setBorder(new CompoundBorder(JBUI.Borders.empty((int)2), textField.getBorder()));
        TextFieldWithCompletion textFieldWithCompletion = textField;
        if (textFieldWithCompletion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createTextField"));
        }
        return textFieldWithCompletion;
    }

    @NotNull
    JBPopup createPopup() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)((Object)this.myTextField), "Center");
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)((Object)this.myTextField)).setCancelOnClickOutside(true).setAdText(KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.CTRL_ENTER.getShortcuts()) + " to finish").setRequestFocus(true).setResizable(true).setMayBeParent(true);
        final JBPopup popup = builder.createPopup();
        popup.setMinimumSize((Dimension)new JBDimension(200, 90));
        DumbAwareAction okAction = new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$2", "actionPerformed"));
                }
                this.unregisterCustomShortcutSet(popup.getContent());
                popup.closeOk(e.getInputEvent());
            }
        };
        okAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, popup.getContent());
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "createPopup"));
        }
        return jBPopup;
    }

    @NotNull
    List<String> getSelectedValues() {
        List list2 = ContainerUtil.mapNotNull((Iterable)StringUtil.tokenize((String)this.myTextField.getText(), (String)new String(SEPARATORS)), value2 -> {
            String trimmed = value2.trim();
            return trimmed.isEmpty() ? null : trimmed;
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder", "getSelectedValues"));
        }
        return list2;
    }

    private static class MyCompletionProvider
    extends ValuesCompletionProvider.ValuesCompletionProviderDumbAware<String> {
        MyCompletionProvider(@NotNull Collection<String> values, boolean supportsNegativeValues) {
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/MultilinePopupBuilder$MyCompletionProvider", "<init>"));
            }
            super(new DefaultTextCompletionValueDescriptor.StringValueDescriptor(), supportsNegativeValues ? ContainerUtil.append((List)Chars.asList((char[])SEPARATORS), (Object[])new Character[]{Character.valueOf('-')}) : Chars.asList((char[])SEPARATORS), values, false);
        }

        @Override
        @Nullable
        public String getAdvertisement() {
            return "Select one or more values separated with | or new lines";
        }
    }
}

