/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    protected final AbstractVcsLogUi myUi;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogData logData, @NotNull AbstractVcsLogUi ui) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/table/GraphTableModel", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/table/GraphTableModel", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/table/GraphTableModel", "<init>"));
        }
        this.myLogData = logData;
        this.myUi = ui;
        this.myDataPack = dataPack;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        VirtualFile virtualFile = this.myDataPack.getRoot(rowIndex);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public Integer getIdAtRow(int row) {
        Integer n = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit();
        if (n == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getIdAtRow"));
        }
        return n;
    }

    @Nullable
    public CommitId getCommitIdAtRow(int row) {
        return this.myLogData.getCommitId(this.getIdAtRow(row));
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/table/GraphTableModel", "getRowOfCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/table/GraphTableModel", "getRowOfCommit"));
        }
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getVisibleGraph()), i2 -> i2 == commitIndex);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        if (partialHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialHash", "com/intellij/vcs/log/ui/table/GraphTableModel", "getRowOfCommitByPartOfHash"));
        }
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<CommitId>)((Condition)commitId1 -> hashByString.value((CommitId)commitId1) && this.getRowOfCommit(commitId1.getHash(), commitId1.getRoot()) != -1));
        return commitId != null ? this.getRowOfCommit(commitId.getHash(), commitId.getRoot()) : -1;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onLoaded", "com/intellij/vcs/log/ui/table/GraphTableModel", "requestToLoadMore"));
        }
        this.myMoreRequested = true;
        this.myUi.getRefresher().moreCommitsNeeded(onLoaded);
        this.myUi.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.getShortDetails(rowIndex);
        switch (columnIndex) {
            case 0: {
                VirtualFile virtualFile = this.getRoot(rowIndex);
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getValueAt"));
                }
                return virtualFile;
            }
            case 1: {
                GraphCommitCell graphCommitCell = new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
                if (graphCommitCell == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getValueAt"));
                }
                return graphCommitCell;
            }
            case 2: {
                String authorString = VcsUserUtil.getShortPresentation(data.getAuthor());
                String string = authorString + (VcsUserUtil.isSamePerson(data.getAuthor(), data.getCommitter()) ? "" : "*");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getValueAt"));
                }
                return string;
            }
            case 3: {
                if (data.getAuthorTime() < 0L) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getValueAt"));
                    }
                    return "";
                }
                String string = DateFormatUtil.formatDateTime((long)data.getAuthorTime());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getValueAt"));
                }
                return string;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + (this.getColumnCount() - 1));
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + (this.getColumnCount() - 1));
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/table/GraphTableModel", "setVisiblePack"));
        }
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        VisiblePack visiblePack = this.myDataPack;
        if (visiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getVisiblePack"));
        }
        return visiblePack;
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row) {
        VcsFullCommitDetails vcsFullCommitDetails = this.getDetails(row, this.myLogData.getCommitDetailsGetter());
        if (vcsFullCommitDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getFullDetails"));
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public VcsShortCommitDetails getShortDetails(int row) {
        VcsShortCommitDetails vcsShortCommitDetails = this.getDetails(row, this.myLogData.getMiniDetailsGetter());
        if (vcsShortCommitDetails == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getShortDetails"));
        }
        return vcsShortCommitDetails;
    }

    @NotNull
    private <T extends VcsShortCommitDetails> T getDetails(int row, @NotNull DataGetter<T> dataGetter) {
        if (dataGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGetter", "com/intellij/vcs/log/ui/table/GraphTableModel", "getDetails"));
        }
        Iterable<Integer> iterable = this.createRowsIterable(row, 20, 40, this.getRowCount());
        T t = dataGetter.getCommitData(this.getIdAtRow(row), iterable);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getDetails"));
        }
        return t;
    }

    @NotNull
    public Collection<VcsRef> getRefsAtRow(int row) {
        Collection<VcsRef> collection = ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getRefsAtRow"));
        }
        return collection;
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row) {
        List<VcsRef> list2 = this.getRefsAtRow(row).stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "getBranchesAtRow"));
        }
        return list2;
    }

    @NotNull
    private Iterable<Integer> createRowsIterable(final int row, final int above, final int below, final int maxRows) {
        Iterable<Integer> iterable = () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row - above);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row + below && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "createRowsIterable"));
        }
        return iterable;
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/vcs/log/ui/table/GraphTableModel", "convertToCommitIds"));
        }
        List list2 = ContainerUtil.map(rows, (Function)((NotNullFunction)this::getIdAtRow));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/GraphTableModel", "convertToCommitIds"));
        }
        return list2;
    }
}

