/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogSpeedSearch;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexSpeedSearch
extends VcsLogSpeedSearch {
    @NotNull
    private final VcsLogIndex myIndex;
    @NotNull
    private final VcsUserRegistry myUserRegistry;
    @Nullable
    private Set<Integer> myMatchedByUserCommits;
    @Nullable
    private Collection<VcsUser> myMatchedUsers;

    public IndexSpeedSearch(@NotNull Project project2, @NotNull VcsLogIndex index, @NotNull VcsLogGraphTable component) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/table/IndexSpeedSearch", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/vcs/log/ui/table/IndexSpeedSearch", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/ui/table/IndexSpeedSearch", "<init>"));
        }
        super(component);
        this.myIndex = index;
        this.myUserRegistry = (VcsUserRegistry)ServiceManager.getService((Project)project2, VcsUserRegistry.class);
        this.addChangeListener(evt -> {
            if (evt.getPropertyName().equals("enteredPrefix")) {
                String newValue = (String)evt.getNewValue();
                if (newValue != null) {
                    String oldValue = (String)evt.getOldValue();
                    Collection<Object> usersToExamine = this.myUserRegistry.getUsers();
                    if (oldValue != null && newValue.contains(oldValue) && this.myMatchedUsers != null) {
                        if (this.myMatchedUsers.isEmpty()) {
                            return;
                        }
                        usersToExamine = this.myMatchedUsers;
                    }
                    this.myMatchedUsers = ContainerUtil.filter((Collection)usersToExamine, user -> this.compare(VcsUserUtil.getShortPresentation(user), newValue));
                    this.myMatchedByUserCommits = this.myIndex.filter(Collections.singletonList(new SimpleVcsLogUserFilter(this.myMatchedUsers)));
                } else {
                    this.myMatchedByUserCommits = null;
                    this.myMatchedUsers = null;
                }
            }
        });
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        if (super.isSpeedSearchEnabled()) {
            VisiblePack visiblePack = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getVisiblePack();
            Set<VirtualFile> roots = visiblePack.getLogProviders().keySet();
            Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(roots, visiblePack.getFilters().getRootFilter(), visiblePack.getFilters().getStructureFilter());
            for (VirtualFile root : visibleRoots) {
                if (this.myIndex.isIndexed(root)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected String getElementText(@NotNull Object row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/vcs/log/ui/table/IndexSpeedSearch", "getElementText"));
        }
        throw new UnsupportedOperationException("Getting row text in a Log is unsupported since we match commit subject and author separately.");
    }

    @Nullable
    private String getCommitSubject(@NotNull Integer row) {
        Integer id;
        String message2;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/vcs/log/ui/table/IndexSpeedSearch", "getCommitSubject"));
        }
        IndexDataGetter dataGetter = this.myIndex.getDataGetter();
        if (dataGetter != null && (message2 = dataGetter.getFullMessage(id = ((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow(row))) != null) {
            return IndexedDetails.getSubject(message2);
        }
        return super.getElementText(row);
    }

    @Override
    protected boolean isMatchingElement(Object row, String pattern) {
        String str = this.getCommitSubject((Integer)row);
        return str != null && this.compare(str, pattern) || this.myMatchedByUserCommits != null && !this.myMatchedByUserCommits.isEmpty() && this.myMatchedByUserCommits.contains(((VcsLogGraphTable)((Object)this.myComponent)).getModel().getIdAtRow((Integer)row));
    }

    private static class SimpleVcsLogUserFilter
    implements VcsLogUserFilter {
        @NotNull
        private final Collection<VcsUser> myMatchedUsers;

        public SimpleVcsLogUserFilter(@NotNull Collection<VcsUser> matchedUsers) {
            if (matchedUsers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchedUsers", "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter", "<init>"));
            }
            this.myMatchedUsers = matchedUsers;
        }

        @NotNull
        public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter", "getUsers"));
            }
            Collection<VcsUser> collection = this.myMatchedUsers;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter", "getUsers"));
            }
            return collection;
        }

        public boolean matches(@NotNull VcsCommitMetadata details) {
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/table/IndexSpeedSearch$SimpleVcsLogUserFilter", "matches"));
            }
            return this.myMatchedUsers.contains(details.getAuthor());
        }
    }
}

