/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsLogProvider;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PersistentUtil {
    @NotNull
    public static final File LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    @NotNull
    public static String calcLogId(@NotNull Project project2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        int hashcode = PersistentUtil.calcLogProvidersHash(logProviders);
        String string = project2.getLocationHash() + "." + Integer.toHexString(hashcode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "calcLogId"));
        }
        return string;
    }

    private static int calcLogProvidersHash(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "calcLogProvidersHash"));
        }
        List sortedRoots = ContainerUtil.sorted(logProviders.keySet(), Comparator.comparing(VirtualFile::getPath));
        return StringUtil.join((Collection)sortedRoots, root -> {
            if (logProviders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/util/PersistentUtil", "lambda$calcLogProvidersHash$0"));
            }
            return root.getPath() + "." + ((VcsLogProvider)logProviders.get(root)).getSupportedVcs().getName();
        }, (String)".").hashCode();
    }

    @NotNull
    public static File getStorageFile(@NotNull String storageKind, @NotNull String logId, int version) {
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        File subdir = new File(LOG_CACHE, storageKind);
        String safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true);
        File mapFile = new File(subdir, safeLogId + "." + version);
        if (!mapFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        }
        File file2 = mapFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        return file2;
    }

    public static void cleanupOldStorageFile(@NotNull String storageKind, @NotNull String logId) {
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "cleanupOldStorageFile"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "cleanupOldStorageFile"));
        }
        File subdir = new File(LOG_CACHE, storageKind);
        String safeLogId = PathUtilRt.suggestFileName((String)logId, (boolean)true, (boolean)true);
        IOUtil.deleteAllFilesStartingWith((File)new File(subdir, safeLogId));
        File[] files = subdir.listFiles();
        if (files != null && files.length == 0) {
            subdir.delete();
        }
    }

    @NotNull
    public static <T> PersistentEnumeratorBase<T> createPersistentEnumerator(@NotNull KeyDescriptor<T> keyDescriptor, @NotNull String storageKind, @NotNull String logId, int version) throws IOException {
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        if (storageKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageKind", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        File storageFile = PersistentUtil.getStorageFile(storageKind, logId, version);
        PersistentEnumeratorBase persistentEnumeratorBase = (PersistentEnumeratorBase)IOUtil.openCleanOrResetBroken(() -> {
            if (keyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "com/intellij/vcs/log/util/PersistentUtil", "lambda$createPersistentEnumerator$1"));
            }
            return new PersistentBTreeEnumerator(storageFile, keyDescriptor, Page.PAGE_SIZE, null, version);
        }, (File)storageFile);
        if (persistentEnumeratorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "createPersistentEnumerator"));
        }
        return persistentEnumeratorBase;
    }

    public static boolean deleteWithRenamingAllFilesStartingWith(@NotNull File baseFile) {
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/vcs/log/util/PersistentUtil", "deleteWithRenamingAllFilesStartingWith"));
        }
        File parentFile = baseFile.getParentFile();
        if (parentFile == null) {
            return false;
        }
        File[] files = parentFile.listFiles(pathname -> {
            if (baseFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/vcs/log/util/PersistentUtil", "lambda$deleteWithRenamingAllFilesStartingWith$2"));
            }
            return pathname.getName().startsWith(baseFile.getName());
        });
        if (files == null) {
            return true;
        }
        boolean deleted = true;
        for (File f : files) {
            deleted &= FileUtil.deleteWithRenaming((File)f);
        }
        return deleted;
    }

    public static boolean cleanupStorageFiles(@NotNull String subdirName, @NotNull String id) {
        if (subdirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "com/intellij/vcs/log/util/PersistentUtil", "cleanupStorageFiles"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/util/PersistentUtil", "cleanupStorageFiles"));
        }
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        return PersistentUtil.deleteWithRenamingAllFilesStartingWith(new File(subdir, safeLogId + "."));
    }

    @NotNull
    public static File getStorageFile(@NotNull String subdirName, @NotNull String kind2, @NotNull String id, int version) {
        if (subdirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        File subdir = new File(LOG_CACHE, subdirName);
        String safeLogId = PathUtilRt.suggestFileName((String)id, (boolean)true, (boolean)true);
        File file2 = PersistentUtil.getFileName(kind2, subdir, safeLogId, version);
        if (!file2.exists()) {
            for (int oldVersion = 0; oldVersion < version; ++oldVersion) {
                IOUtil.deleteAllFilesStartingWith((File)PersistentUtil.getFileName(kind2, subdir, safeLogId, oldVersion));
            }
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getStorageFile"));
        }
        return file3;
    }

    @NotNull
    private static File getFileName(@NotNull String kind2, @NotNull File subdir, @NotNull String safeLogId, int version) {
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/vcs/log/util/PersistentUtil", "getFileName"));
        }
        if (subdir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdir", "com/intellij/vcs/log/util/PersistentUtil", "getFileName"));
        }
        if (safeLogId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safeLogId", "com/intellij/vcs/log/util/PersistentUtil", "getFileName"));
        }
        File file2 = new File(subdir, safeLogId + "." + kind2 + "." + version);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getFileName"));
        }
        return file2;
    }

    @NotNull
    public static File getCorruptionMarkerFile() {
        File file2 = new File(LOG_CACHE, CORRUPTION_MARKER);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/PersistentUtil", "getCorruptionMarkerFile"));
        }
        return file2;
    }
}

