/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Couple;
import com.intellij.vcs.log.VcsUser;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserUtil {
    @NotNull
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)[\\W_](\\w+)");
    @NotNull
    private static final Pattern PRINTABLE_ASCII_PATTERN = Pattern.compile("[ -~]*");

    @NotNull
    public static String toExactString(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "toExactString"));
        }
        String string = VcsUserUtil.getString(user.getName(), user.getEmail());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "toExactString"));
        }
        return string;
    }

    @NotNull
    private static String getString(@NotNull String name2, @NotNull String email) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        if (name2.isEmpty()) {
            String string = email;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
            }
            return string;
        }
        if (email.isEmpty()) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
            }
            return string;
        }
        String string = name2 + " <" + email + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getString"));
        }
        return string;
    }

    public static boolean isSamePerson(@NotNull VcsUser user1, @NotNull VcsUser user2) {
        if (user1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user1", "com/intellij/vcs/log/util/VcsUserUtil", "isSamePerson"));
        }
        if (user2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user2", "com/intellij/vcs/log/util/VcsUserUtil", "isSamePerson"));
        }
        return VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user1)).equals(VcsUserUtil.getNameInStandardForm(VcsUserUtil.getName(user2)));
    }

    @NotNull
    public static String getShortPresentation(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "getShortPresentation"));
        }
        String string = VcsUserUtil.getName(user);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getShortPresentation"));
        }
        return string;
    }

    @NotNull
    private static String getName(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/util/VcsUserUtil", "getName"));
        }
        String string = VcsUserUtil.getUserName(user.getName(), user.getEmail());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getName"));
        }
        return string;
    }

    @NotNull
    public static String getUserName(@NotNull String name2, @NotNull String email) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        if (!name2.isEmpty()) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
            }
            return string;
        }
        String emailNamePart = VcsUserUtil.getNameFromEmail(email);
        if (emailNamePart != null) {
            String string = emailNamePart;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
            }
            return string;
        }
        String string = email;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getUserName"));
        }
        return string;
    }

    @Nullable
    public static String getNameFromEmail(@NotNull String email) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "getNameFromEmail"));
        }
        int at = email.indexOf(64);
        String emailNamePart = null;
        if (at > 0) {
            emailNamePart = email.substring(0, at);
        }
        return emailNamePart;
    }

    @NotNull
    public static String getNameInStandardForm(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
        }
        Couple<String> firstAndLastName = VcsUserUtil.getFirstAndLastName(name2);
        if (firstAndLastName != null) {
            String string = ((String)firstAndLastName.first).toLowerCase(Locale.ENGLISH) + " " + ((String)firstAndLastName.second).toLowerCase(Locale.ENGLISH);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
            }
            return string;
        }
        String string = VcsUserUtil.nameToLowerCase(name2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "getNameInStandardForm"));
        }
        return string;
    }

    @Nullable
    public static Couple<String> getFirstAndLastName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "getFirstAndLastName"));
        }
        Matcher matcher = NAME_PATTERN.matcher(name2);
        if (matcher.matches()) {
            return Couple.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return null;
    }

    @NotNull
    public static String nameToLowerCase(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name2).matches()) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
            }
            return string;
        }
        String string = name2.toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "nameToLowerCase"));
        }
        return string;
    }

    @NotNull
    public static String capitalizeName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
        }
        if (name2.isEmpty()) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
            }
            return string;
        }
        if (!PRINTABLE_ASCII_PATTERN.matcher(name2).matches()) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
            }
            return string;
        }
        String string = name2.substring(0, 1).toUpperCase(Locale.ENGLISH) + name2.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "capitalizeName"));
        }
        return string;
    }

    @NotNull
    public static String emailToLowerCase(@NotNull String email) {
        if (email == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "email", "com/intellij/vcs/log/util/VcsUserUtil", "emailToLowerCase"));
        }
        String string = email.toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsUserUtil", "emailToLowerCase"));
        }
        return string;
    }
}

