/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "isEnabled"));
        }
        Promise<String> textPromise = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2);
        if (textPromise.getState() == Promise.State.PENDING) {
            return true;
        }
        if (textPromise.getState() == Promise.State.REJECTED) {
            return false;
        }
        return textPromise.blockingGet(0) != null;
    }

    @NotNull
    protected static Promise<String> getTextToEvaluate(DataContext dataContext, XDebugSession session2) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            Promise promise2 = Promise.resolve(null);
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "getTextToEvaluate"));
            }
            return promise2;
        }
        String text2 = editor.getSelectionModel().getSelectedText();
        if (text2 != null) {
            Promise promise3 = Promise.resolve((Object)StringUtil.nullize((String)text2, (boolean)true));
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "getTextToEvaluate"));
            }
            return promise3;
        }
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator != null) {
            Promise promise4 = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor).then(s -> StringUtil.nullize((String)s, (boolean)true));
            if (promise4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "getTextToEvaluate"));
            }
            return promise4;
        }
        Promise promise5 = Promise.resolve(null);
        if (promise5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "getTextToEvaluate"));
        }
        return promise5;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "perform"));
        }
        XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session2).done(text2 -> {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "lambda$perform$2"));
            }
            if (text2 == null) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (session2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler", "lambda$null$1"));
                }
                ((XDebugSessionImpl)session2).getSessionTab().getWatchesView().addWatchExpression(XExpressionImpl.fromText(text2), -1, true);
            });
        });
    }
}

