/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(XValueHint.class);
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final XDebuggerEvaluator myEvaluator;
    private final XDebugSession myDebugSession;
    private final boolean myFromKeyboard;
    private final String myExpression;
    private final String myValueName;
    private final XSourcePosition myExpressionPosition;
    private Disposable myDisposable;
    private static final Key<XValueHint> HINT_KEY = Key.create((String)"allows only one value hint per editor");

    public XValueHint(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type2, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSession session2, boolean fromKeyboard) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        this(project2, session2.getDebugProcess().getEditorsProvider(), editor, point, type2, expressionInfo, evaluator, session2, fromKeyboard);
    }

    protected XValueHint(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type2, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, boolean fromKeyboard) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        this(project2, editorsProvider, editor, point, type2, expressionInfo, evaluator, null, fromKeyboard);
    }

    private XValueHint(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type2, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @Nullable XDebugSession session2, boolean fromKeyboard) {
        LanguageConsoleView console;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorsProvider", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (expressionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfo", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "<init>"));
        }
        super(project2, editor, point, type2, expressionInfo.getTextRange());
        this.myEditorsProvider = editorsProvider;
        this.myEvaluator = evaluator;
        this.myDebugSession = session2;
        this.myFromKeyboard = fromKeyboard;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText(expressionInfo, editor.getDocument());
        ConsoleView consoleView = (ConsoleView)ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW.get((UserDataHolder)editor);
        VirtualFile file2 = consoleView instanceof LanguageConsoleView ? ((console = (LanguageConsoleView)consoleView).getHistoryViewer() == editor ? console.getVirtualFile() : null) : FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file2 != null ? XDebuggerUtil.getInstance().createPositionByOffset(file2, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    @Override
    protected boolean canShowHint() {
        return true;
    }

    @Override
    protected boolean showHint(JComponent component) {
        boolean result2 = super.showHint(component);
        if (result2) {
            XValueHint prev = (XValueHint)this.getEditor().getUserData(HINT_KEY);
            if (prev != null) {
                prev.hideHint();
            }
            this.getEditor().putUserData(HINT_KEY, (Object)this);
        }
        return result2;
    }

    @Override
    protected void onHintHidden() {
        super.onHintHidden();
        XValueHint prev = (XValueHint)this.getEditor().getUserData(HINT_KEY);
        if (prev == this) {
            this.getEditor().putUserData(HINT_KEY, null);
        }
        this.disposeVisibleHint();
    }

    @Override
    public void hideHint() {
        super.hideHint();
        this.disposeVisibleHint();
    }

    @Override
    protected void evaluateAndShowHint() {
        final AtomicBoolean showEvaluating = new AtomicBoolean(true);
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            if (this.myCurrentHint == null && showEvaluating.get()) {
                SimpleColoredComponent component = HintUtil.createInformationComponent();
                component.append(XDebuggerUIConstants.EVALUATING_EXPRESSION_MESSAGE);
                this.showHint((JComponent)component);
            }
        }, 200L, TimeUnit.MILLISECONDS);
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "evaluated"));
                }
                result2.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;
                    private boolean myShown = false;

                    @Override
                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1", "applyPresentation"));
                        }
                        showEvaluating.set(false);
                        if (XValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text2 = new SimpleColoredText();
                        text2.append(StringUtil.trimMiddle((String)XValueHint.this.myValueName, (int)200), XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        XValueNodeImpl.buildText(valuePresenter, (ColoredTextContainer)text2);
                        if (!hasChildren) {
                            JComponent component = XValueHint.this.createHintComponent(text2, valuePresenter, this.myFullValueEvaluator);
                            XValueHint.this.showHint(component);
                        } else if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            if (!this.myShown) {
                                XValueHint.this.showTree(result2);
                            }
                        } else {
                            if (XValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                if (XValueHint.this.myFromKeyboard) {
                                    text2.insert(0, "(" + KeymapUtil.getFirstKeyboardShortcutText((String)"ShowErrorDescription") + ") ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                }
                                XValueHint.this.disposeVisibleHint();
                                XValueHint.this.myDisposable = Disposer.newDisposable();
                                ShortcutSet shortcut = ActionManager.getInstance().getAction("ShowErrorDescription").getShortcutSet();
                                new DumbAwareAction(){

                                    public void actionPerformed(@NotNull AnActionEvent e) {
                                        if (e == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1$1", "actionPerformed"));
                                        }
                                        XValueHint.this.showTree(result2);
                                    }
                                }.registerCustomShortcutSet(shortcut, XValueHint.this.getEditor().getContentComponent(), XValueHint.this.myDisposable);
                            }
                            XValueHint.this.showHint(XValueHint.this.createExpandableHintComponent(text2, () -> {
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1", "lambda$applyPresentation$0"));
                                }
                                XValueHint.this.showTree(result2);
                            }));
                        }
                        this.myShown = true;
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1$1", "setFullValueEvaluator"));
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return XValueHint.this.isHintHidden();
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "errorOccurred"));
                }
                showEvaluating.set(false);
                if (XValueHint.this.myCurrentHint != null) {
                    XValueHint.this.myCurrentHint.hide();
                }
                if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "lambda$errorOccurred$0"));
                        }
                        XValueHint.this.showHint(HintUtil.createErrorLabel(errorMessage));
                    });
                }
                LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
            }
        }, this.myExpressionPosition);
    }

    @NotNull
    protected JComponent createHintComponent(@NotNull SimpleColoredText text2, @NotNull XValuePresentation presentation, @Nullable XFullValueEvaluator evaluator) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "createHintComponent"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "createHintComponent"));
        }
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        text2.appendToComponent((ColoredTextContainer)component);
        if (evaluator != null) {
            component.append(evaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, event -> DebuggerUIUtil.showValuePopup(evaluator, event, this.getProject(), this.getEditor()));
            LinkMouseListenerBase.installSingleTagOn(component);
        }
        SimpleColoredComponent simpleColoredComponent = component;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "createHintComponent"));
        }
        return simpleColoredComponent;
    }

    private void disposeVisibleHint() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void showTree(@NotNull XValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint", "showTree"));
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
        }
        XValueMarkers<?, ?> valueMarkers = this.myDebugSession == null ? null : ((XDebugSessionImpl)this.myDebugSession).getValueMarkers();
        XSourcePosition position = this.myDebugSession == null ? null : this.myDebugSession.getCurrentPosition();
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.getProject(), this.myEditorsProvider, position, valueMarkers);
        this.showTreePopup(creator, Pair.create((Object)value2, (Object)this.myValueName));
    }

    public String toString() {
        return this.myExpression;
    }
}

