/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.frame.XDebugView;
import org.jetbrains.annotations.NotNull;

public class XDebugViewSessionListener
implements XDebugSessionListener {
    private final XDebugView myDebugView;
    private final XDebugSession mySession;

    private XDebugViewSessionListener(@NotNull XDebugView debugView, @NotNull XDebugSession session2) {
        if (debugView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugView", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "<init>"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "<init>"));
        }
        this.myDebugView = debugView;
        this.mySession = session2;
    }

    public static void attach(@NotNull XDebugView debugView, @NotNull XDebugSession session2) {
        if (debugView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugView", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "attach"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "attach"));
        }
        session2.addSessionListener((XDebugSessionListener)new XDebugViewSessionListener(debugView, session2));
    }

    private void onSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XDebugViewSessionListener", "onSessionEvent"));
        }
        this.myDebugView.processSessionEvent(event, this.mySession);
    }

    public void sessionPaused() {
        this.onSessionEvent(XDebugView.SessionEvent.PAUSED);
    }

    public void sessionResumed() {
        this.onSessionEvent(XDebugView.SessionEvent.RESUMED);
    }

    public void sessionStopped() {
        this.onSessionEvent(XDebugView.SessionEvent.STOPPED);
    }

    public void stackFrameChanged() {
        this.onSessionEvent(XDebugView.SessionEvent.FRAME_CHANGED);
    }

    public void beforeSessionResume() {
        this.onSessionEvent(XDebugView.SessionEvent.BEFORE_RESUME);
    }
}

