/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ClickListener;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.CodeFragmentInputComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorBase {
    private final Project myProject;
    private final XDebuggerEditorsProvider myDebuggerEditorsProvider;
    @NotNull
    private final EvaluationMode myMode;
    @Nullable
    private final String myHistoryId;
    @Nullable
    private XSourcePosition mySourcePosition;
    private int myHistoryIndex;
    @Nullable
    private PsiElement myContext;
    private final JLabel myChooseFactory;
    private WeakReference<ListPopup> myPopup;

    protected XDebuggerEditorBase(Project project2, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @NotNull EvaluationMode mode, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerEditorsProvider", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "<init>"));
        }
        this.myHistoryIndex = -1;
        this.myChooseFactory = new JLabel();
        this.myProject = project2;
        this.myDebuggerEditorsProvider = debuggerEditorsProvider;
        this.myMode = mode;
        this.myHistoryId = historyId;
        this.mySourcePosition = sourcePosition;
        this.myChooseFactory.setToolTipText(XDebuggerBundle.message((String)"xdebugger.evaluate.language.hint", (Object[])new Object[0]));
        this.myChooseFactory.setBorder((Border)JBUI.Borders.empty((int)0, (int)3, (int)0, (int)3));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$1", "onClick"));
                }
                if (XDebuggerEditorBase.this.myChooseFactory.isEnabled()) {
                    ListPopup oldPopup = (ListPopup)SoftReference.dereference((Reference)XDebuggerEditorBase.this.myPopup);
                    if (oldPopup != null && !oldPopup.isDisposed()) {
                        oldPopup.cancel();
                        XDebuggerEditorBase.this.myPopup = null;
                        return true;
                    }
                    ListPopup popup = XDebuggerEditorBase.this.createLanguagePopup();
                    popup.showUnderneathOf((Component)XDebuggerEditorBase.this.myChooseFactory);
                    XDebuggerEditorBase.this.myPopup = new WeakReference<ListPopup>(popup);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myChooseFactory);
    }

    private ListPopup createLanguagePopup() {
        DefaultActionGroup actions = new DefaultActionGroup();
        for (final Language language : this.getSupportedLanguages()) {
            actions.add(new AnAction(language.getDisplayName(), null, language.getAssociatedFileType().getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase$2", "actionPerformed"));
                    }
                    XExpression currentExpression = XDebuggerEditorBase.this.getExpression();
                    XDebuggerEditorBase.this.setExpression(new XExpressionImpl(currentExpression.getExpression(), language, currentExpression.getCustomInfo()));
                    XDebuggerEditorBase.this.requestFocusInEditor();
                }
            });
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.getComponent());
        return JBPopupFactory.getInstance().createActionGroupPopup("Choose Language", (ActionGroup)actions, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @NotNull
    private Collection<Language> getSupportedLanguages() {
        XDebuggerEditorsProvider editorsProvider = this.getEditorsProvider();
        if (this.myContext != null && editorsProvider instanceof XDebuggerEditorsProviderBase) {
            Collection collection = ((XDebuggerEditorsProviderBase)editorsProvider).getSupportedLanguages(this.myContext);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getSupportedLanguages"));
            }
            return collection;
        }
        Collection collection = editorsProvider.getSupportedLanguages(this.myProject, this.mySourcePosition);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getSupportedLanguages"));
        }
        return collection;
    }

    protected JPanel decorate(JComponent component, boolean multiline, boolean showEditor) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel();
        BorderLayoutPanel factoryPanel = JBUI.Panels.simplePanel();
        factoryPanel.add((Component)this.myChooseFactory, multiline ? "North" : "Center");
        panel2.add((Component)factoryPanel, (Object)"West");
        if (!multiline && showEditor) {
            component = this.addMultilineButton(component);
        }
        panel2.addToCenter((Component)component);
        return panel2;
    }

    protected JPanel addMultilineButton(JComponent component) {
        ComponentWithBrowseButton componentWithButton = new ComponentWithBrowseButton(component, e -> this.showCodeFragmentEditor(component, this));
        componentWithButton.setButtonIcon(AllIcons.Actions.ShowViewer);
        componentWithButton.getButton().setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.ShowViewer));
        return componentWithButton;
    }

    protected JComponent addChooser(JComponent component) {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)component);
        panel2.setBackground(component.getBackground());
        panel2.addToRight((Component)this.myChooseFactory);
        return panel2;
    }

    public void setContext(@Nullable PsiElement context) {
        if (this.myContext != context) {
            this.myContext = context;
            this.setExpression(this.getExpression());
        }
    }

    public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
        if (this.mySourcePosition != sourcePosition) {
            this.mySourcePosition = sourcePosition;
            this.setExpression(this.getExpression());
        }
    }

    @NotNull
    public EvaluationMode getMode() {
        EvaluationMode evaluationMode = this.myMode;
        if (evaluationMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getMode"));
        }
        return evaluationMode;
    }

    @Nullable
    public abstract Editor getEditor();

    public abstract JComponent getComponent();

    public JComponent getEditorComponent() {
        return this.getComponent();
    }

    protected abstract void doSetText(XExpression var1);

    public void setExpression(@Nullable XExpression text2) {
        Collection<Language> languages;
        boolean many;
        Language language;
        if (text2 == null) {
            XExpression xExpression = text2 = this.getMode() == EvaluationMode.EXPRESSION ? XExpressionImpl.EMPTY_EXPRESSION : XExpressionImpl.EMPTY_CODE_FRAGMENT;
        }
        if ((language = text2.getLanguage()) == null) {
            if (this.myContext != null) {
                language = this.myContext.getLanguage();
            }
            if (language == null && this.mySourcePosition != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)this.mySourcePosition.getFile());
            }
            if (language == null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)this.getEditorsProvider().getFileType());
            }
            text2 = new XExpressionImpl(text2.getExpression(), language, text2.getCustomInfo(), text2.getMode());
        }
        boolean bl = many = (languages = this.getSupportedLanguages()).size() > 1;
        if (language != null) {
            this.myChooseFactory.setVisible(many);
        }
        this.myChooseFactory.setVisible(this.myChooseFactory.isVisible() || many);
        if (language != null && language.getAssociatedFileType() != null) {
            LayeredIcon icon = (LayeredIcon)JBUI.scale((JBUI.JBIcon)new LayeredIcon(2));
            icon.setIcon(language.getAssociatedFileType().getIcon(), 0);
            icon.setIcon(AllIcons.General.Dropdown, 1, 3, 0);
            this.myChooseFactory.setIcon((Icon)icon);
            this.myChooseFactory.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        }
        this.doSetText(text2);
    }

    public abstract XExpression getExpression();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    public void requestFocusInEditor() {
        JComponent preferredFocusedComponent = this.getPreferredFocusedComponent();
        if (preferredFocusedComponent != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusedComponent, true);
        }
    }

    public abstract void selectAll();

    protected void onHistoryChanged() {
    }

    public List<XExpression> getRecentExpressions() {
        if (this.myHistoryId != null) {
            return XDebuggerHistoryManager.getInstance(this.myProject).getRecentExpressions(this.myHistoryId);
        }
        return Collections.emptyList();
    }

    public void saveTextInHistory() {
        this.saveTextInHistory(this.getExpression());
    }

    private void saveTextInHistory(XExpression text2) {
        if (this.myHistoryId != null) {
            boolean update2 = XDebuggerHistoryManager.getInstance(this.myProject).addRecentExpression(this.myHistoryId, text2);
            this.myHistoryIndex = -1;
            if (update2) {
                this.onHistoryChanged();
            }
        }
    }

    @NotNull
    protected FileType getFileType(@NotNull XExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getFileType"));
        }
        FileType fileType = LanguageUtil.getLanguageFileType((Language)expression2.getLanguage());
        if (fileType != null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getFileType"));
            }
            return fileType2;
        }
        FileType fileType3 = this.getEditorsProvider().getFileType();
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/XDebuggerEditorBase", "getFileType"));
        }
        return fileType3;
    }

    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myDebuggerEditorsProvider;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected Document createDocument(XExpression text2) {
        XDebuggerEditorsProvider provider = this.getEditorsProvider();
        if (this.myContext != null && provider instanceof XDebuggerEditorsProviderBase) {
            return ((XDebuggerEditorsProviderBase)provider).createDocument(this.getProject(), text2, this.myContext, this.myMode);
        }
        return provider.createDocument(this.getProject(), text2, this.mySourcePosition, this.myMode);
    }

    public boolean canGoBackward() {
        return this.myHistoryIndex < this.getRecentExpressions().size() - 1;
    }

    public boolean canGoForward() {
        return this.myHistoryIndex > 0;
    }

    public void goBackward() {
        List<XExpression> expressions2 = this.getRecentExpressions();
        if (this.myHistoryIndex < expressions2.size() - 1) {
            ++this.myHistoryIndex;
            this.setExpression(expressions2.get(this.myHistoryIndex));
        }
    }

    public void goForward() {
        List<XExpression> expressions2 = this.getRecentExpressions();
        if (this.myHistoryIndex > 0) {
            --this.myHistoryIndex;
            this.setExpression(expressions2.get(this.myHistoryIndex));
        }
    }

    private void showCodeFragmentEditor(Component parent, final XDebuggerEditorBase baseEditor) {
        DialogWrapper dialog2 = new DialogWrapper(parent, true){
            CodeFragmentInputComponent inputComponent;
            {
                super(arg0, arg1);
                this.inputComponent = new CodeFragmentInputComponent(baseEditor.getProject(), baseEditor.getEditorsProvider(), XDebuggerEditorBase.this.mySourcePosition, XExpressionImpl.changeMode(baseEditor.getExpression(), EvaluationMode.CODE_FRAGMENT), null, null);
                this.setTitle("Edit");
                this.init();
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return "#xdebugger.code.fragment.editor";
            }

            @Nullable
            protected JComponent createCenterPanel() {
                JPanel component = this.inputComponent.getMainComponent();
                component.setPreferredSize((Dimension)JBUI.size((int)300, (int)200));
                return component;
            }

            protected void doOKAction() {
                super.doOKAction();
                baseEditor.setExpression(this.inputComponent.getInputEditor().getExpression());
                JComponent component = baseEditor.getPreferredFocusedComponent();
                if (component != null) {
                    IdeFocusManager.findInstance().requestFocus((Component)component, false);
                }
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.inputComponent.getInputEditor().getPreferredFocusedComponent();
            }
        };
        dialog2.show();
    }
}

