/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeInplaceEditor
implements AWTEventListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeInplaceEditor");
    private JComponent myInplaceEditorComponent;
    private final List<Runnable> myRemoveActions = new ArrayList<Runnable>();
    protected final Disposable myDisposable = Disposer.newDisposable();

    protected abstract JComponent createInplaceEditorComponent();

    protected abstract JComponent getPreferredFocusedComponent();

    public abstract Editor getEditor();

    public abstract JComponent getEditorComponent();

    protected abstract TreePath getNodePath();

    protected abstract JTree getTree();

    protected void doPopupOKAction() {
        this.doOKAction();
    }

    public void doOKAction() {
        this.hide();
    }

    public void cancelEditing() {
        this.hide();
    }

    private void hide() {
        if (!this.isShown()) {
            return;
        }
        this.myInplaceEditorComponent = null;
        this.onHidden();
        this.myRemoveActions.forEach(Runnable::run);
        this.myRemoveActions.clear();
        Disposer.dispose((Disposable)this.myDisposable);
        JTree tree = this.getTree();
        tree.repaint();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)tree, true));
    }

    protected void onHidden() {
    }

    protected abstract Project getProject();

    private static void setInplaceEditorBounds(JComponent component, int x, int y, int width, int height) {
        int h = Math.max(height, component.getPreferredSize().height);
        component.setBounds(x, y - (h - height) / 2, width, h);
    }

    public final void show() {
        JComponent inplaceEditorComponent;
        LOG.assertTrue(this.myInplaceEditorComponent == null, (Object)"editor is not released");
        JTree tree = this.getTree();
        tree.scrollPathToVisible(this.getNodePath());
        JRootPane rootPane = tree.getRootPane();
        if (rootPane == null) {
            return;
        }
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Rectangle bounds = this.getEditorBounds();
        if (bounds == null) {
            return;
        }
        Point layeredPanePoint = SwingUtilities.convertPoint(tree, bounds.x, bounds.y, layeredPane);
        this.myInplaceEditorComponent = inplaceEditorComponent = this.createInplaceEditorComponent();
        LOG.assertTrue(inplaceEditorComponent != null);
        TreeInplaceEditor.setInplaceEditorBounds(inplaceEditorComponent, layeredPanePoint.x, layeredPanePoint.y, bounds.width, bounds.height);
        layeredPane.add((Component)inplaceEditorComponent, new Integer(250));
        this.myRemoveActions.add(() -> layeredPane.remove(inplaceEditorComponent));
        inplaceEditorComponent.validate();
        inplaceEditorComponent.paintImmediately(0, 0, inplaceEditorComponent.getWidth(), inplaceEditorComponent.getHeight());
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getPreferredFocusedComponent(), true));
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Project project2 = TreeInplaceEditor.this.getProject();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!TreeInplaceEditor.this.isShown() || project2 == null || project2.isDisposed()) {
                        return;
                    }
                    JTree tree1 = TreeInplaceEditor.this.getTree();
                    JLayeredPane layeredPane1 = tree1.getRootPane().getLayeredPane();
                    Rectangle bounds1 = TreeInplaceEditor.this.getEditorBounds();
                    if (bounds1 == null) {
                        return;
                    }
                    Point layeredPanePoint1 = SwingUtilities.convertPoint(tree1, bounds1.x, bounds1.y, layeredPane1);
                    TreeInplaceEditor.setInplaceEditorBounds(inplaceEditorComponent, layeredPanePoint1.x, layeredPanePoint1.y, bounds1.width, bounds1.height);
                    inplaceEditorComponent.revalidate();
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        };
        HierarchyListener hierarchyListener = e -> {
            if (!tree.isShowing()) {
                this.cancelEditing();
            }
        };
        tree.addHierarchyListener(hierarchyListener);
        tree.addComponentListener(componentListener);
        rootPane.addComponentListener(componentListener);
        this.myRemoveActions.add(() -> {
            tree.removeHierarchyListener(hierarchyListener);
            tree.removeComponentListener(componentListener);
            rootPane.removeComponentListener(componentListener);
        });
        this.getProject().getMessageBus().connect(this.myDisposable).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/xdebugger/impl/ui/tree/TreeInplaceEditor$2", "contentSelected"));
                }
                TreeInplaceEditor.this.cancelEditing();
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/xdebugger/impl/ui/tree/TreeInplaceEditor$2", "contentRemoved"));
                }
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        JComponent editorComponent = this.getEditorComponent();
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enterStroke");
        editorComponent.getActionMap().put("enterStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.doOKAction();
            }
        });
        editorComponent.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escapeStroke");
        editorComponent.getActionMap().put("escapeStroke", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeInplaceEditor.this.cancelEditing();
            }
        });
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        SwingUtilities.invokeLater(() -> {
            if (!this.isShown()) {
                return;
            }
            defaultToolkit.addAWTEventListener(this, 131088L);
        });
        this.myRemoveActions.add(() -> defaultToolkit.removeAWTEventListener(this));
        this.onShown();
    }

    protected void onShown() {
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Component componentAtPoint;
        LookupImpl activeLookup;
        if (!this.isShown()) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        if (mouseEvent.getClickCount() == 0 && !(event instanceof MouseWheelEvent)) {
            return;
        }
        int id = mouseEvent.getID();
        if (id != 501 && id != 502 && id != 500 && id != 507) {
            return;
        }
        Component sourceComponent = mouseEvent.getComponent();
        Point originalPoint = mouseEvent.getPoint();
        Editor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        Project project2 = editor.getProject();
        LookupImpl lookupImpl = activeLookup = project2 != null ? (LookupImpl)LookupManager.getInstance(project2).getActiveLookup() : null;
        if (activeLookup != null) {
            Point lookupPoint = SwingUtilities.convertPoint(sourceComponent, originalPoint, activeLookup.getComponent());
            if (activeLookup.getComponent().getBounds().contains(lookupPoint)) {
                return;
            }
            activeLookup.hide();
        }
        List popups = JBPopupFactory.getInstance().getChildPopups((Component)this.myInplaceEditorComponent);
        for (JBPopup popup : popups) {
            if (!SwingUtilities.isDescendingFrom(sourceComponent, popup.getContent())) continue;
            return;
        }
        Point point = SwingUtilities.convertPoint(sourceComponent, originalPoint, this.myInplaceEditorComponent);
        if (this.myInplaceEditorComponent.contains(point)) {
            return;
        }
        for (Component comp = componentAtPoint = SwingUtilities.getDeepestComponentAt(sourceComponent, originalPoint.x, originalPoint.y); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof ComboPopup)) continue;
            if (id != 507) {
                this.doPopupOKAction();
            }
            return;
        }
        if (id != 502) {
            this.cancelEditing();
        }
    }

    @Nullable
    protected Rectangle getEditorBounds() {
        JTree tree = this.getTree();
        Rectangle bounds = tree.getVisibleRect();
        Rectangle nodeBounds = tree.getPathBounds(this.getNodePath());
        if (bounds == null || nodeBounds == null) {
            return null;
        }
        bounds.y = nodeBounds.y;
        bounds.height = nodeBounds.height;
        if (nodeBounds.x > bounds.x) {
            bounds.width = bounds.width - nodeBounds.x + bounds.x;
            bounds.x = nodeBounds.x;
        }
        return bounds;
    }

    public boolean isShown() {
        return this.myInplaceEditorComponent != null;
    }
}

