/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.enumeration.EmptyEnumeration;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeNode
implements TreeNode,
TreeSpeedSearch.PathAwareTreeNode {
    protected final XDebuggerTree myTree;
    private final XDebuggerTreeNode myParent;
    private boolean myLeaf;
    protected final SimpleColoredText myText = new SimpleColoredText();
    private Icon myIcon;
    private TreePath myPath;

    protected XDebuggerTreeNode(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, boolean leaf) {
        this.myParent = parent;
        this.myLeaf = leaf;
        this.myTree = tree;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.isLeaf() ? null : this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.isLeaf() ? 0 : this.getChildren().size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(@NotNull TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode", "getIndex"));
        }
        if (this.isLeaf()) {
            return -1;
        }
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myLeaf;
    }

    public Enumeration children() {
        if (this.isLeaf()) {
            return EmptyEnumeration.INSTANCE;
        }
        return Collections.enumeration(this.getChildren());
    }

    @NotNull
    public abstract List<? extends TreeNode> getChildren();

    protected void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void setLeaf(boolean leaf) {
        this.myLeaf = leaf;
    }

    @Nullable
    public XDebuggerTreeNodeHyperlink getLink() {
        return null;
    }

    @NotNull
    public SimpleColoredText getText() {
        SimpleColoredText simpleColoredText = this.myText;
        if (simpleColoredText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode", "getText"));
        }
        return simpleColoredText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void fireNodeChanged() {
        this.myTree.getTreeModel().nodeChanged(this);
    }

    protected void fireNodesRemoved(int[] indices2, TreeNode[] nodes) {
        if (indices2.length > 0) {
            this.myTree.getTreeModel().nodesWereRemoved(this, indices2, nodes);
        }
    }

    protected void fireNodesInserted(Collection<? extends TreeNode> added) {
        if (!added.isEmpty()) {
            this.myTree.getTreeModel().nodesWereInserted(this, this.getNodesIndices(added));
        }
    }

    protected TreeNode[] getChildNodes(int[] indices2) {
        TreeNode[] children2 = new TreeNode[indices2.length];
        for (int i2 = 0; i2 < indices2.length; ++i2) {
            children2[i2] = this.getChildAt(indices2[i2]);
        }
        return children2;
    }

    protected int[] getNodesIndices(@Nullable Collection<? extends TreeNode> children2) {
        if (children2 == null) {
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] ints = new int[children2.size()];
        int i2 = 0;
        for (TreeNode treeNode : children2) {
            ints[i2++] = this.getIndex(treeNode);
        }
        Arrays.sort(ints);
        return ints;
    }

    protected void fireNodeStructureChanged() {
        this.fireNodeStructureChanged(this);
    }

    protected void fireNodeStructureChanged(TreeNode node) {
        this.myTree.getTreeModel().nodeStructureChanged(node);
    }

    public XDebuggerTree getTree() {
        return this.myTree;
    }

    @Override
    public TreePath getPath() {
        if (this.myPath == null) {
            TreePath path = this.myParent == null ? new TreePath(this) : this.myParent.getPath().pathByAddingChild(this);
            this.myPath = path;
        }
        return this.myPath;
    }

    @NotNull
    public abstract List<? extends XDebuggerTreeNode> getLoadedChildren();

    public abstract void clearChildren();

    public void appendToComponent(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode", "appendToComponent"));
        }
        this.getText().appendToComponent(component);
        XDebuggerTreeNodeHyperlink link = this.getLink();
        if (link != null) {
            component.append(link.getLinkText(), link.getTextAttributes(), (Object)link);
        }
    }

    public void invokeNodeUpdate(Runnable runnable2) {
        this.myTree.getLaterInvocator().offer((Object)runnable2);
    }
}

