/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlArrangementVisitor;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlRearranger
implements Rearranger<XmlElementArrangementEntry>,
ArrangementStandardSettingsAware {
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.XML_TAG, StdArrangementTokens.EntryType.XML_ATTRIBUTE});
    private static final List<StdArrangementMatchRule> DEFAULT_MATCH_RULES = new ArrayList<StdArrangementMatchRule>();
    private static final StdArrangementSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    @NotNull
    public static StdArrangementMatchRule attrArrangementRule(@NotNull String nameFilter, @NotNull String namespaceFilter, @NotNull ArrangementSettingsToken orderType) {
        if (nameFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFilter", "com/intellij/xml/arrangement/XmlRearranger", "attrArrangementRule"));
        }
        if (namespaceFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceFilter", "com/intellij/xml/arrangement/XmlRearranger", "attrArrangementRule"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderType", "com/intellij/xml/arrangement/XmlRearranger", "attrArrangementRule"));
        }
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)nameFilter), new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.XML_NAMESPACE, (Object)namespaceFilter)})), orderType);
        if (stdArrangementMatchRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/arrangement/XmlRearranger", "attrArrangementRule"));
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/arrangement/XmlRearranger", "getSerializer"));
        }
        return defaultArrangementSettingsSerializer;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/xml/arrangement/XmlRearranger", "isEnabled"));
        }
        return SUPPORTED_TYPES.contains(token) || StdArrangementTokens.Regexp.NAME.equals((Object)token) || StdArrangementTokens.Regexp.XML_NAMESPACE.equals((Object)token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token);
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        Set<Set<ArrangementSettingsToken>> set2 = Collections.singleton(SUPPORTED_TYPES);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/arrangement/XmlRearranger", "getMutexes"));
        }
        return set2;
    }

    @Nullable
    public Pair<XmlElementArrangementEntry, List<XmlElementArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/xml/arrangement/XmlRearranger", "parseWithNew"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/xml/arrangement/XmlRearranger", "parseWithNew"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/arrangement/XmlRearranger", "parseWithNew"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xml/arrangement/XmlRearranger", "parseWithNew"));
        }
        XmlArrangementParseInfo newEntryInfo = new XmlArrangementParseInfo();
        element.accept((PsiElementVisitor)new XmlArrangementVisitor(newEntryInfo, Collections.singleton(element.getTextRange())));
        if (newEntryInfo.getEntries().size() != 1) {
            return null;
        }
        XmlElementArrangementEntry entry = newEntryInfo.getEntries().get(0);
        XmlArrangementParseInfo existingEntriesInfo = new XmlArrangementParseInfo();
        root.accept((PsiElementVisitor)new XmlArrangementVisitor(existingEntriesInfo, ranges));
        return Pair.create((Object)((Object)entry), existingEntriesInfo.getEntries());
    }

    @NotNull
    public List<XmlElementArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/xml/arrangement/XmlRearranger", "parse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/xml/arrangement/XmlRearranger", "parse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xml/arrangement/XmlRearranger", "parse"));
        }
        XmlArrangementParseInfo parseInfo = new XmlArrangementParseInfo();
        root.accept((PsiElementVisitor)new XmlArrangementVisitor(parseInfo, ranges));
        List<XmlElementArrangementEntry> list2 = parseInfo.getEntries();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/arrangement/XmlRearranger", "parse"));
        }
        return list2;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable XmlElementArrangementEntry parent, @Nullable XmlElementArrangementEntry previous, @NotNull XmlElementArrangementEntry target2) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xml/arrangement/XmlRearranger", "getBlankLines"));
        }
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/xml/arrangement/XmlRearranger", "getBlankLines"));
        }
        return -1;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return null;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, SUPPORTED_TYPES), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.XML_NAMESPACE), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition2) throws IllegalArgumentException {
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/xml/arrangement/XmlRearranger", "buildMatcher"));
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition2);
    }

    static {
        DEFAULT_MATCH_RULES.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)"xmlns:.*"))));
        DEFAULT_SETTINGS = StdArrangementSettings.createByMatchRules(Collections.emptyList(), DEFAULT_MATCH_RULES);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);
    }
}

