/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsInitializingActivity
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "runActivity"));
        }
        if (project2.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || project2.isDisposed()) {
            return;
        }
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$1", "fileTypesChanged"));
                }
                BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project2);
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(project2), (Disposable)project2);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "lambda$runActivity$0"));
            }
            BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project2);
        });
    }

    private static void reinitBreadcrumbsInAllEditors(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "reinitBreadcrumbsInAllEditors"));
        }
        if (project2.isDisposed()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, virtualFile);
        }
    }

    private static void reinitBreadcrumbsComponent(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "reinitBreadcrumbsComponent"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "reinitBreadcrumbsComponent"));
        }
        boolean above = EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            BreadcrumbsXmlWrapper wrapper = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor);
            if (BreadcrumbsInitializingActivity.isSuitable(textEditor, file2)) {
                if (wrapper != null) {
                    if (wrapper.breadcrumbs.above != above) {
                        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper);
                        wrapper.breadcrumbs.above = above;
                        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper);
                    }
                    wrapper.queueUpdate();
                    continue;
                }
                BreadcrumbsInitializingActivity.registerWrapper(fileEditorManager, fileEditor, new BreadcrumbsXmlWrapper(editor));
                continue;
            }
            if (wrapper == null) continue;
            BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper);
        }
    }

    private static boolean isSuitable(@NotNull TextEditor editor, @NotNull VirtualFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "isSuitable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "isSuitable"));
        }
        if (file2 instanceof HttpVirtualFile) {
            return false;
        }
        return editor.isValid() && BreadcrumbsXmlWrapper.findInfoProvider(editor.getEditor(), file2) != null;
    }

    private static void add(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "add"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "add"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "add"));
        }
        if (wrapper.breadcrumbs.above) {
            manager.addTopComponent(editor, (JComponent)wrapper);
        } else {
            manager.addBottomComponent(editor, (JComponent)wrapper);
        }
    }

    private static void remove(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "remove"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "remove"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "remove"));
        }
        if (wrapper.breadcrumbs.above) {
            manager.removeTopComponent(editor, (JComponent)wrapper);
        } else {
            manager.removeBottomComponent(editor, (JComponent)wrapper);
        }
    }

    private static void registerWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "registerWrapper"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "registerWrapper"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "registerWrapper"));
        }
        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper);
        Disposer.register((Disposable)fileEditor, () -> {
            if (fileEditorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "lambda$registerWrapper$1"));
            }
            if (fileEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "lambda$registerWrapper$1"));
            }
            if (wrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "lambda$registerWrapper$1"));
            }
            BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper);
        });
    }

    private static void disposeWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper) {
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "disposeWrapper"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "disposeWrapper"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity", "disposeWrapper"));
        }
        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper);
        Disposer.dispose((Disposable)wrapper);
    }

    private static class MyVirtualFileListener
    implements VirtualFileListener {
        private final Project myProject;

        public MyVirtualFileListener(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyVirtualFileListener", "<init>"));
            }
            this.myProject = project2;
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            FileEditorManager fileEditorManager;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName()) && !this.myProject.isDisposed() && (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).isFileOpen(file2 = event.getFile())) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, file2);
            }
        }
    }

    private static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsInitializingActivity$MyFileEditorManagerListener", "fileOpened"));
            }
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(source, file2);
        }
    }
}

