/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightingAwareElementDescriptor;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.xml.impl.dom.AbstractDomChildrenDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementXmlDescriptor
extends AbstractDomChildrenDescriptor
implements XmlHighlightingAwareElementDescriptor {
    private final DomChildrenDescription myChildrenDescription;

    public DomElementXmlDescriptor(@NotNull DomElement domElement) {
        if (domElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/xml/impl/dom/DomElementXmlDescriptor", "<init>"));
        }
        super(domElement.getManager());
        this.myChildrenDescription = new MyRootDomChildrenDescription(domElement);
    }

    public DomElementXmlDescriptor(@NotNull DomChildrenDescription childrenDescription, DomManager manager) {
        if (childrenDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenDescription", "com/intellij/xml/impl/dom/DomElementXmlDescriptor", "<init>"));
        }
        super(manager);
        this.myChildrenDescription = childrenDescription;
    }

    public String getDefaultName() {
        return this.myChildrenDescription.getXmlElementName();
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myChildrenDescription.getDeclaration(this.myManager.getProject());
    }

    @Override
    @NonNls
    public String getName(PsiElement context) {
        String name2 = this.getDefaultName();
        if (context instanceof XmlTag) {
            XmlTag tag = (XmlTag)context;
            PsiFile file2 = tag.getContainingFile();
            DomElement element = this.myManager.getDomElement(tag);
            if (element == null && tag.getParentTag() != null) {
                element = this.myManager.getDomElement(tag.getParentTag());
            }
            if (element != null && file2 instanceof XmlFile && !(this.myChildrenDescription instanceof MyRootDomChildrenDescription)) {
                String s;
                String namespace = DomService.getInstance().getEvaluatedXmlName(element).evaluateChildName(this.myChildrenDescription.getXmlName()).getNamespace((XmlElement)tag, (XmlFile)file2);
                if (!tag.getNamespaceByPrefix("").equals(namespace) && StringUtil.isNotEmpty((String)(s = tag.getPrefixByNamespace(namespace)))) {
                    return s + ":" + name2;
                }
            }
        }
        return name2;
    }

    @Override
    public boolean shouldCheckRequiredAttributes() {
        return false;
    }

    @Presentation(typeName="Root Tag")
    private static class MyRootDomChildrenDescription
    implements DomChildrenDescription {
        private final DomElement myDomElement;

        public MyRootDomChildrenDescription(DomElement domElement) {
            this.myDomElement = domElement;
        }

        public String getName() {
            return this.getXmlElementName();
        }

        public boolean isValid() {
            return true;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        public XmlName getXmlName() {
            throw new UnsupportedOperationException("Method getXmlName not implemented in " + this.getClass());
        }

        @NotNull
        public String getXmlElementName() {
            String string = this.myDomElement.getXmlElementName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getXmlElementName"));
            }
            return string;
        }

        @NotNull
        public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
            if (strategy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getCommonPresentableName"));
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + this.getClass());
        }

        @NotNull
        public String getCommonPresentableName(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getCommonPresentableName"));
            }
            throw new UnsupportedOperationException("Method getCommonPresentableName not implemented in " + this.getClass());
        }

        @NotNull
        public List<? extends DomElement> getValues(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getValues"));
            }
            throw new UnsupportedOperationException("Method getValues not implemented in " + this.getClass());
        }

        @NotNull
        public List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getStableValues"));
            }
            throw new UnsupportedOperationException("Method getStableValues not implemented in " + this.getClass());
        }

        @NotNull
        public Type getType() {
            throw new UnsupportedOperationException("Method getType not implemented in " + this.getClass());
        }

        @NotNull
        public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/xml/impl/dom/DomElementXmlDescriptor$MyRootDomChildrenDescription", "getDomNameStrategy"));
            }
            throw new UnsupportedOperationException("Method getDomNameStrategy not implemented in " + this.getClass());
        }

        public <T> T getUserData(Key<T> key2) {
            return null;
        }

        public ElementPresentationTemplate getPresentationTemplate() {
            return null;
        }

        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            throw new UnsupportedOperationException("Method getAnnotation not implemented in " + this.getClass());
        }

        @Nullable
        public PsiElement getDeclaration(Project project2) {
            return PomService.convertToPsi((Project)project2, (PomTarget)this);
        }

        public DomElement getDomDeclaration() {
            return this.myDomElement;
        }

        public boolean isStubbed() {
            return false;
        }
    }
}

