/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsdNamespaceBuilder
extends NanoXmlUtil.IXMLBuilderAdapter
implements Comparable<XsdNamespaceBuilder> {
    private String myCurrentTag;
    private int myCurrentDepth;
    private String myNamespace;
    private String myVersion;
    private final List<String> myTags;
    private final Set<String> myReferencedTags = new HashSet<String>();
    private final List<String> myRootTags;
    private final List<String> myAttributes = new ArrayList<String>();

    public static String computeNamespace(InputStream is) {
        return XsdNamespaceBuilder.computeNamespace(new InputStreamReader(is)).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XsdNamespaceBuilder computeNamespace(Reader reader) {
        try {
            XsdNamespaceBuilder builder = new XsdNamespaceBuilder();
            NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder);
            HashSet<String> tags = new HashSet<String>(builder.getTags());
            tags.removeAll(builder.myReferencedTags);
            builder.getRootTags().addAll(tags);
            XsdNamespaceBuilder xsdNamespaceBuilder = builder;
            return xsdNamespaceBuilder;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void startElement(@NonNls String name2, @NonNls String nsPrefix, @NonNls String nsURI, String systemID, int lineNr) throws Exception {
        if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
            this.myCurrentTag = name2;
        }
        ++this.myCurrentDepth;
    }

    public void endElement(String name2, String nsPrefix, String nsURI) throws Exception {
        --this.myCurrentDepth;
        this.myCurrentTag = null;
    }

    public void addAttribute(@NonNls String key2, String nsPrefix, String nsURI, String value2, String type2) throws Exception {
        if (this.myCurrentDepth == 1 && "schema".equals(this.myCurrentTag)) {
            if ("targetNamespace".equals(key2)) {
                this.myNamespace = value2;
            } else if ("version".equals(key2)) {
                this.myVersion = value2;
            }
        } else if ("element".equals(this.myCurrentTag)) {
            if (this.myCurrentDepth < 3 && "name".equals(key2)) {
                this.myTags.add(value2);
            } else if ("ref".equals(key2)) {
                this.myReferencedTags.add(XmlUtil.getLocalName(value2).toString());
            }
        }
    }

    @Override
    public int compareTo(@NotNull XsdNamespaceBuilder o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/xml/index/XsdNamespaceBuilder", "compareTo"));
        }
        return Comparing.compare((Comparable)((Object)this.myNamespace), (Comparable)((Object)o.myNamespace));
    }

    public boolean hasTag(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/xml/index/XsdNamespaceBuilder", "hasTag"));
        }
        return this.myTags.contains(tagName);
    }

    public int getRating(@Nullable String tagName, @Nullable String version) {
        int rate = 0;
        if (tagName != null && this.myTags.contains(tagName)) {
            rate |= 2;
        }
        if (version != null && version.equals(this.myVersion)) {
            rate |= 1;
        }
        return rate;
    }

    private XsdNamespaceBuilder() {
        this.myTags = new ArrayList<String>();
        this.myRootTags = new ArrayList<String>();
    }

    XsdNamespaceBuilder(String namespace, String version, List<String> tags, List<String> rootTags) {
        this.myNamespace = namespace;
        this.myVersion = version;
        this.myTags = tags;
        this.myRootTags = rootTags;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<String> getTags() {
        return this.myTags;
    }

    public List<String> getRootTags() {
        return this.myRootTags;
    }

    public List<String> getAttributes() {
        return this.myAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsdNamespaceBuilder builder = (XsdNamespaceBuilder)o;
        if (this.myNamespace != null ? !this.myNamespace.equals(builder.myNamespace) : builder.myNamespace != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(builder.myVersion) : builder.myVersion != null) {
            return false;
        }
        return !(this.myTags != null ? !this.myTags.equals(builder.myTags) : builder.myTags != null);
    }

    public int hashCode() {
        int result2 = this.myNamespace != null ? this.myNamespace.hashCode() : 0;
        result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result2 = 31 * result2 + (this.myTags != null ? this.myTags.hashCode() : 0);
        return result2;
    }
}

