/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.template.formatter.CompositeTemplateBlock;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.intellij.xml.template.formatter.TemplateSyntheticBlock;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlTemplateFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder {
    @Override
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            FormattingModel model;
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)psiFile.getViewProvider();
            if (this.isTemplateFile(psiFile)) {
                Language templateDataLanguage = viewProvider.getTemplateDataLanguage();
                if (templateDataLanguage != psiFile.getLanguage()) {
                    FormattingModel formattingModel = this.createDataLanguageFormattingModel((PsiElement)viewProvider.getPsi(templateDataLanguage), templateDataLanguage, settings, psiFile, Indent.getNoneIndent());
                    if (formattingModel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createModel"));
                    }
                    return formattingModel;
                }
            } else if (element instanceof OuterLanguageElement && this.isOuterLanguageElement(element) && (model = this.createTemplateFormattingModel(psiFile, viewProvider, (OuterLanguageElement)element, settings, Indent.getNoneIndent())) != null) {
                FormattingModel formattingModel = model;
                if (formattingModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createModel"));
                }
                return formattingModel;
            }
        }
        FormattingModel formattingModel = super.createModel(element, settings);
        if (formattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createModel"));
        }
        return formattingModel;
    }

    @Nullable
    FormattingModel createTemplateFormattingModel(@NotNull PsiFile psiFile, @NotNull TemplateLanguageFileViewProvider viewProvider, @NotNull OuterLanguageElement outerTemplateElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createTemplateFormattingModel"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createTemplateFormattingModel"));
        }
        if (outerTemplateElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerTemplateElement", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createTemplateFormattingModel"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "createTemplateFormattingModel"));
        }
        List<PsiElement> templateElements = TemplateFormatUtil.findAllTemplateLanguageElementsInside((PsiElement)outerTemplateElement, viewProvider);
        return this.createTemplateFormattingModel(psiFile, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), templateElements, indent);
    }

    @Nullable
    public FormattingModel createTemplateFormattingModel(PsiFile file2, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, List<PsiElement> elements, Indent indent) {
        if (elements.size() == 0) {
            return null;
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        for (PsiElement element : elements) {
            if (this.isMarkupLanguageElement(element) || FormatterUtil.containsWhiteSpacesOnly(element.getNode())) continue;
            templateBlocks.add(this.createTemplateLanguageBlock(element.getNode(), settings, xmlFormattingPolicy, indent, null, null));
        }
        if (templateBlocks.size() == 0) {
            return null;
        }
        CompositeTemplateBlock topBlock = templateBlocks.size() == 1 ? (Block)templateBlocks.get(0) : new CompositeTemplateBlock(templateBlocks);
        return new DocumentBasedFormattingModel(topBlock, file2.getProject(), settings, file2.getFileType(), file2);
    }

    protected abstract boolean isTemplateFile(PsiFile var1);

    public abstract boolean isOuterLanguageElement(PsiElement var1);

    public abstract boolean isMarkupLanguageElement(PsiElement var1);

    private FormattingModel createDataLanguageFormattingModel(PsiElement dataElement, Language language, CodeStyleSettings settings, PsiFile psiFile, @Nullable Indent indent) {
        Block block = this.createDataLanguageRootBlock(dataElement, language, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), psiFile, indent);
        return new DocumentBasedFormattingModel(block, psiFile.getProject(), settings, psiFile.getFileType(), psiFile);
    }

    public Block createDataLanguageRootBlock(PsiElement dataElement, Language language, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, PsiFile psiFile, Indent indent) {
        AbstractBlock block;
        if (dataElement instanceof XmlTag) {
            block = this.createXmlTagBlock(dataElement.getNode(), null, null, xmlFormattingPolicy, indent);
        } else if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            block = this.createXmlBlock(dataElement.getNode(), null, Alignment.createAlignment(), xmlFormattingPolicy, indent, dataElement.getTextRange());
        } else {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(language, dataElement);
            if (builder != null && !AbstractXmlTemplateFormattingModelBuilder.isInsideXmlAttributeValue(dataElement)) {
                FormattingModel otherLanguageModel = builder.createModel(dataElement, settings);
                block = otherLanguageModel.getRootBlock();
            } else {
                block = new ReadOnlyBlock(dataElement.getNode());
            }
        }
        return block;
    }

    protected abstract Block createTemplateLanguageBlock(ASTNode var1, CodeStyleSettings var2, XmlFormattingPolicy var3, Indent var4, @Nullable Alignment var5, @Nullable Wrap var6);

    protected XmlTagBlock createXmlTagBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent) {
        return new TemplateXmlTagBlock(this, node, wrap, alignment, policy, indent);
    }

    protected XmlBlock createXmlBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent, @Nullable TextRange textRange) {
        return new TemplateXmlBlock(this, node, wrap, alignment, policy, indent, textRange);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        return new TemplateSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    public List<Block> mergeWithTemplateBlocks(List<Block> markupBlocks, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        int templateLangRangeStart = Integer.MAX_VALUE;
        int templateLangRangeEnd = -1;
        int rangeStart = Integer.MAX_VALUE;
        int rangeEnd = -1;
        PsiFile templateFile = null;
        ArrayList<Block> pureMarkupBlocks = new ArrayList<Block>();
        for (Block block : markupBlocks) {
            AnotherLanguageBlockWrapper wrapper;
            PsiElement otherLangElement;
            TextRange currRange = block.getTextRange();
            rangeStart = Math.min(currRange.getStartOffset(), rangeStart);
            rangeEnd = Math.max(currRange.getEndOffset(), rangeEnd);
            boolean isMarkupBlock = true;
            if (block instanceof AnotherLanguageBlockWrapper && this.isOuterLanguageElement(otherLangElement = (wrapper = (AnotherLanguageBlockWrapper)block).getNode().getPsi())) {
                isMarkupBlock = false;
                if (templateFile == null) {
                    FileViewProvider provider = otherLangElement.getContainingFile().getViewProvider();
                    templateFile = provider.getPsi(provider.getBaseLanguage());
                }
                templateLangRangeStart = Math.min(currRange.getStartOffset(), templateLangRangeStart);
                templateLangRangeEnd = Math.max(currRange.getEndOffset(), templateLangRangeEnd);
            }
            if (!isMarkupBlock) continue;
            pureMarkupBlocks.add(block);
        }
        if (templateLangRangeEnd > templateLangRangeStart && templateFile != null) {
            List<Block> templateBlocks = this.buildTemplateLanguageBlocksInside(templateFile, new TextRange(templateLangRangeStart, templateLangRangeEnd), settings, xmlFormattingPolicy, childrenIndent);
            if (pureMarkupBlocks.isEmpty()) {
                return this.afterMerge(templateBlocks, true, settings, xmlFormattingPolicy);
            }
            return this.afterMerge(TemplateFormatUtil.mergeBlocks(pureMarkupBlocks, templateBlocks, new TextRange(rangeStart, rangeEnd)), false, settings, xmlFormattingPolicy);
        }
        return markupBlocks;
    }

    private List<Block> buildTemplateLanguageBlocksInside(@NotNull PsiFile templateFile, @NotNull TextRange range, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) {
        if (templateFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateFile", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "buildTemplateLanguageBlocksInside"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "buildTemplateLanguageBlocksInside"));
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)templateFile.getViewProvider();
        List<PsiElement> templateElements = TemplateFormatUtil.findAllElementsInside(range, viewProvider, true);
        FormattingModel localModel = this.createTemplateFormattingModel(templateFile, settings, xmlFormattingPolicy, templateElements, childrenIndent);
        if (localModel != null) {
            Block rootBlock = localModel.getRootBlock();
            if (rootBlock instanceof CompositeTemplateBlock) {
                templateBlocks.addAll(rootBlock.getSubBlocks());
            } else {
                templateBlocks.add(rootBlock);
            }
        }
        return templateBlocks;
    }

    protected List<Block> afterMerge(List<Block> originalBlocks, boolean templateOnly, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFormattingPolicy", "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder", "afterMerge"));
        }
        return originalBlocks;
    }

    protected static XmlFormattingPolicy getPolicy(CodeStyleSettings settings, PsiFile psiFile) {
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn(psiFile);
        return new HtmlPolicy(settings, documentModel);
    }

    private static boolean isInsideXmlAttributeValue(PsiElement element) {
        XmlAttributeValue value2 = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)true);
        return value2 != null;
    }
}

