/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFormatUtil {
    private static final List<PsiElement> EMPTY_PSI_ELEMENT_LIST = new ArrayList<PsiElement>();
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]), XmlErrorMessages.message("xml.parsing.closing.tag.name.missing", new Object[0])};

    private TemplateFormatUtil() {
    }

    @NotNull
    static List<PsiElement> findAllMarkupLanguageElementsInside(PsiElement outerLangElement) {
        PsiFile file2 = outerLangElement.getContainingFile();
        if (file2 != null && file2.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)file2.getViewProvider();
            List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, false);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllMarkupLanguageElementsInside"));
            }
            return list2;
        }
        List<PsiElement> list3 = EMPTY_PSI_ELEMENT_LIST;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllMarkupLanguageElementsInside"));
        }
        return list3;
    }

    @NotNull
    static List<PsiElement> findAllTemplateLanguageElementsInside(@NotNull PsiElement outerLangElement, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        if (outerLangElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerLangElement", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllTemplateLanguageElementsInside"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllTemplateLanguageElementsInside"));
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, true);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllTemplateLanguageElementsInside"));
        }
        return list2;
    }

    @NotNull
    static List<PsiElement> findAllElementsInside(@NotNull TextRange range, @NotNull TemplateLanguageFileViewProvider viewProvider, boolean fromTemplate) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllElementsInside"));
        }
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewProvider", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllElementsInside"));
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(range, viewProvider, viewProvider.getBaseLanguage(), fromTemplate ? viewProvider.getBaseLanguage() : viewProvider.getTemplateDataLanguage());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllElementsInside"));
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> findAllElementsInside(TextRange range, TemplateLanguageFileViewProvider viewProvider, Language templateLanguage, Language language) {
        ArrayList<PsiElement> matchingElements = new ArrayList<PsiElement>();
        PsiElement currElement = viewProvider.findElementAt(range.getStartOffset(), language);
        while (currElement instanceof OuterLanguageElement) {
            currElement = currElement.getNextSibling();
        }
        if (currElement != null) {
            currElement = TemplateFormatUtil.findTopmostElementInRange(currElement, range);
            Pair<Integer, PsiElement> result2 = TemplateFormatUtil.addElementSequence(currElement, templateLanguage, range, matchingElements, templateLanguage == language);
            int lastOffset = (Integer)result2.first;
            assert (lastOffset >= 0) : "Failed to process elements in range: " + range;
            if (lastOffset < range.getEndOffset()) {
                List<PsiElement> moreElements = TemplateFormatUtil.findAllElementsInside(new TextRange(lastOffset, range.getEndOffset()), viewProvider, templateLanguage, language);
                matchingElements.addAll(moreElements);
            }
        }
        ArrayList<PsiElement> arrayList = matchingElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findAllElementsInside"));
        }
        return arrayList;
    }

    private static Pair<Integer, PsiElement> addElementSequence(PsiElement startElement, Language templateLanguage, TextRange range, List<PsiElement> targetList, boolean fromTemplate) {
        PsiElement child;
        PsiElement currElement;
        int lastOffset = -1;
        for (currElement = startElement; currElement != null && (lastOffset = currElement.getTextRange().getEndOffset()) <= range.getEndOffset(); currElement = currElement.getNextSibling()) {
            boolean isTemplateLanguage = currElement.getLanguage().is(templateLanguage);
            if (fromTemplate != isTemplateLanguage) continue;
            targetList.add(currElement);
        }
        if (currElement != null && currElement.getTextRange().intersects(range) && (child = currElement.getFirstChild()) != null) {
            TemplateFormatUtil.addElementSequence(child, templateLanguage, range, targetList, fromTemplate);
        }
        return new Pair((Object)lastOffset, (Object)currElement);
    }

    @NotNull
    public static PsiElement findTopmostElementInRange(@NotNull PsiElement original, TextRange fitToRange) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findTopmostElementInRange"));
        }
        PsiElement prevElement = original;
        for (PsiElement currElement = original; currElement != null; currElement = currElement.getParent()) {
            if (currElement instanceof PsiFile || !fitToRange.contains(currElement.getTextRange())) {
                if (!fitToRange.contains(prevElement.getTextRange())) {
                    PsiElement psiElement = original;
                    if (psiElement == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findTopmostElementInRange"));
                    }
                    return psiElement;
                }
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findTopmostElementInRange"));
                }
                return psiElement;
            }
            prevElement = currElement;
        }
        PsiElement psiElement = original;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/template/formatter/TemplateFormatUtil", "findTopmostElementInRange"));
        }
        return psiElement;
    }

    static List<Block> mergeBlocks(List<Block> originalBlocks, List<Block> blocksToMerge, TextRange range) throws FragmentedTemplateException {
        if (blocksToMerge.isEmpty()) {
            return originalBlocks;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        if (originalBlocks.isEmpty()) {
            for (Block mergeCandidate : blocksToMerge) {
                if (!range.contains(mergeCandidate.getTextRange())) continue;
                result2.add(mergeCandidate);
            }
            return result2;
        }
        ArrayList<TextRange> originalRanges = new ArrayList<TextRange>();
        for (Block originalBlock : originalBlocks) {
            originalRanges.add(originalBlock.getTextRange());
        }
        int lastOffset = range.getStartOffset();
        Iterator<Block> originalBlockIterator = originalBlocks.iterator();
        while (originalBlockIterator.hasNext()) {
            Block mergeableBlock;
            Block originalBlock = originalBlockIterator.next();
            int startOffset = originalBlock.getTextRange().getStartOffset();
            if (lastOffset < startOffset && (lastOffset = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, lastOffset, startOffset)) < startOffset) {
                lastOffset = TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, lastOffset, startOffset);
            }
            if ((mergeableBlock = TemplateFormatUtil.getBlockContaining(blocksToMerge, originalRanges, originalBlock.getTextRange())) != null) {
                if (mergeableBlock.getTextRange().getStartOffset() < lastOffset) continue;
                result2.add(mergeableBlock);
                lastOffset = mergeableBlock.getTextRange().getEndOffset();
                continue;
            }
            if (startOffset < lastOffset) continue;
            result2.add(originalBlock);
            originalBlockIterator.remove();
            lastOffset = originalBlock.getTextRange().getEndOffset();
        }
        if (lastOffset < range.getEndOffset() && (lastOffset = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, lastOffset, range.getEndOffset())) < range.getEndOffset()) {
            TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, lastOffset, range.getEndOffset());
        }
        return result2;
    }

    private static int fillGap(List<TextRange> originalRanges, List<Block> blocks, List<Block> result2, int startOffset, int endOffset) throws FragmentedTemplateException {
        return TemplateFormatUtil.fillGap(null, originalRanges, blocks, result2, startOffset, endOffset, 0);
    }

    private static int fillGap(@Nullable Block parent, List<TextRange> originalRanges, List<Block> blocks, List<Block> result2, int startOffset, int endOffset, int depth) throws FragmentedTemplateException {
        int lastOffset = startOffset;
        TextRange currRange = new TextRange(lastOffset, endOffset);
        for (Block block : blocks) {
            if (lastOffset == endOffset || block.getTextRange().getStartOffset() > endOffset) {
                return lastOffset;
            }
            if (currRange.contains(block.getTextRange())) {
                result2.add(block);
                if (parent != null && block instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)block).setIndent(parent.getIndent());
                }
                lastOffset = block.getTextRange().getEndOffset();
                currRange = new TextRange(lastOffset, endOffset);
                continue;
            }
            if (!currRange.intersects(block.getTextRange()) || !TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges)) continue;
            List subBlocks = block.getSubBlocks();
            if (block instanceof TemplateLanguageBlock && ((TemplateLanguageBlock)block).containsErrorElements()) {
                throw new FragmentedTemplateException();
            }
            lastOffset = TemplateFormatUtil.fillGap(block, originalRanges, subBlocks, result2, lastOffset, endOffset, depth + 1);
            currRange = new TextRange(lastOffset, endOffset);
        }
        return lastOffset;
    }

    public static boolean intersectsOneOf(TextRange blockRange, List<TextRange> originalRanges) {
        return TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getStartOffset()) || TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getEndOffset());
    }

    static boolean rangesContain(List<TextRange> ranges, int startIndex, int endIndex, int offset) {
        if (endIndex < startIndex || ranges.size() <= startIndex || ranges.size() <= endIndex) {
            return false;
        }
        int startOffset = ranges.get(startIndex).getStartOffset();
        int endOffset = ranges.get(endIndex).getEndOffset();
        if (offset < startOffset || offset > endOffset) {
            return false;
        }
        if (startIndex == endIndex) {
            return true;
        }
        int midIndex = (endIndex + startIndex) / 2;
        return TemplateFormatUtil.rangesContain(ranges, startIndex, midIndex, offset) || TemplateFormatUtil.rangesContain(ranges, midIndex + 1, endIndex, offset);
    }

    private static Block getBlockContaining(List<Block> blockList, List<TextRange> originalRanges, TextRange range) {
        return TemplateFormatUtil.getBlockContaining(blockList, originalRanges, range, 0);
    }

    @Nullable
    private static Block getBlockContaining(List<Block> blockList, List<TextRange> originalRanges, TextRange range, int depth) {
        for (Block block : blockList) {
            Block containingBlock;
            if (!block.getTextRange().contains(range)) continue;
            if (TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges) && (containingBlock = TemplateFormatUtil.getBlockContaining(block.getSubBlocks(), originalRanges, range, depth + 1)) != null) {
                return containingBlock;
            }
            return block;
        }
        return null;
    }

    @Nullable
    public static Block buildTemplateLanguageBlock(@NotNull OuterLanguageElement outerElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        FormattingModel model;
        Language language;
        FormattingModelBuilder builder;
        if (outerElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerElement", "com/intellij/xml/template/formatter/TemplateFormatUtil", "buildTemplateLanguageBlock"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/xml/template/formatter/TemplateFormatUtil", "buildTemplateLanguageBlock"));
        }
        PsiFile file2 = outerElement.getContainingFile();
        FileViewProvider viewProvider = outerElement.getContainingFile().getViewProvider();
        if (viewProvider instanceof TemplateLanguageFileViewProvider && (builder = LanguageFormatting.INSTANCE.forContext(language = outerElement.getLanguage(), (PsiElement)outerElement)) instanceof AbstractXmlTemplateFormattingModelBuilder && (model = ((AbstractXmlTemplateFormattingModelBuilder)builder).createTemplateFormattingModel(file2, (TemplateLanguageFileViewProvider)viewProvider, outerElement, settings, indent)) != null) {
            return model.getRootBlock();
        }
        return null;
    }

    public static boolean isErrorElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/template/formatter/TemplateFormatUtil", "isErrorElement"));
        }
        if (element instanceof PsiErrorElement) {
            String description = ((PsiErrorElement)element).getErrorDescription();
            for (String ignorableMessage : IGNORABLE_ERROR_MESSAGES) {
                if (!ignorableMessage.equals(description)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

