/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlRefCountHolder;
import org.jetbrains.annotations.NotNull;

public class XmlDuplicatedIdInspection
extends XmlSuppressableInspectionTool
implements UnfairLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/xml/util/XmlDuplicatedIdInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                if (value2.getTextRange().isEmpty()) {
                    return;
                }
                PsiFile file2 = value2.getContainingFile();
                if (!(file2 instanceof XmlFile)) {
                    return;
                }
                PsiFile baseFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file2);
                if (baseFile != file2 && !(baseFile instanceof XmlFile)) {
                    return;
                }
                XmlRefCountHolder refHolder = XmlRefCountHolder.getRefCountHolder((XmlFile)file2);
                if (refHolder == null) {
                    return;
                }
                PsiElement parent = value2.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return;
                }
                XmlTag tag = (XmlTag)parent.getParent();
                if (tag == null) {
                    return;
                }
                XmlDuplicatedIdInspection.this.checkValue(value2, (XmlFile)file2, refHolder, tag, holder);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlDuplicatedIdInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    protected void checkValue(XmlAttributeValue value2, XmlFile file2, XmlRefCountHolder refHolder, XmlTag tag, ProblemsHolder holder) {
        if (refHolder.isValidatable(tag.getParent()) && refHolder.isDuplicateIdAttributeValue(value2)) {
            holder.registerProblem((PsiElement)value2, XmlErrorMessages.message("duplicate.id.reference", new Object[0]), ProblemHighlightType.GENERIC_ERROR, ElementManipulators.getValueTextRange((PsiElement)value2), new LocalQuickFix[0]);
        }
    }
}

