/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsonSchemaMappingsProjectConfiguration", storages={@Storage(file="$PROJECT_CONFIG_DIR$/jsonSchemas.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class JsonSchemaMappingsProjectConfiguration
implements PersistentStateComponent<MyState> {
    public volatile MyState myState = new MyState();

    public static JsonSchemaMappingsProjectConfiguration getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "getInstance"));
        }
        return (JsonSchemaMappingsProjectConfiguration)ServiceManager.getService((Project)project2, JsonSchemaMappingsProjectConfiguration.class);
    }

    @Nullable
    public MyState getState() {
        return this.myState;
    }

    public void schemaFileMoved(@NotNull Project project2, @NotNull String oldRelativePath, @NotNull String newRelativePath) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "schemaFileMoved"));
        }
        if (oldRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRelativePath", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "schemaFileMoved"));
        }
        if (newRelativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRelativePath", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "schemaFileMoved"));
        }
        Optional<UserDefinedJsonSchemaConfiguration> old = this.myState.myState.values().stream().filter(schema -> {
            if (oldRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRelativePath", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "lambda$schemaFileMoved$0"));
            }
            return FileUtil.pathsEqual((String)schema.getRelativePathToSchema(), (String)oldRelativePath);
        }).findFirst();
        old.ifPresent(configuration -> {
            if (newRelativePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRelativePath", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "lambda$schemaFileMoved$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "lambda$schemaFileMoved$1"));
            }
            configuration.setRelativePathToSchema(newRelativePath);
            JsonSchemaService.Impl.get(project2).reset();
        });
    }

    public Map<String, UserDefinedJsonSchemaConfiguration> getStateMap() {
        return Collections.unmodifiableMap(this.myState.myState);
    }

    public void loadState(MyState state) {
        this.myState = state;
    }

    public void setState(@NotNull Map<String, UserDefinedJsonSchemaConfiguration> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "setState"));
        }
        this.myState = new MyState(state);
    }

    static class MyState {
        @Tag(value="state")
        @AbstractCollection(surroundWithTag=false)
        public Map<String, UserDefinedJsonSchemaConfiguration> myState = new TreeMap<String, UserDefinedJsonSchemaConfiguration>();

        public MyState() {
        }

        public MyState(Map<String, UserDefinedJsonSchemaConfiguration> state) {
            this.myState = state;
        }
    }
}

