/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaPatternComparator {
    @NotNull
    private final Project myProject;

    public JsonSchemaPatternComparator(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    public ThreeState isSimilar(@NotNull UserDefinedJsonSchemaConfiguration.Item itemLeft, @NotNull UserDefinedJsonSchemaConfiguration.Item itemRight) {
        if (itemLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemLeft", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "isSimilar"));
        }
        if (itemRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemRight", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "isSimilar"));
        }
        if (itemLeft.isPattern() != itemRight.isPattern()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "isSimilar"));
            }
            return threeState;
        }
        if (itemLeft.isPattern()) {
            ThreeState threeState = JsonSchemaPatternComparator.comparePatterns(itemLeft, itemRight);
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "isSimilar"));
            }
            return threeState;
        }
        ThreeState threeState = this.comparePaths(itemLeft, itemRight);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "isSimilar"));
        }
        return threeState;
    }

    private ThreeState comparePaths(UserDefinedJsonSchemaConfiguration.Item left, UserDefinedJsonSchemaConfiguration.Item right) {
        File leftFile = new File(this.myProject.getBasePath(), left.getPath());
        File rightFile = new File(this.myProject.getBasePath(), right.getPath());
        if (left.isDirectory() && FileUtil.isAncestor((File)leftFile, (File)rightFile, (boolean)true)) {
            return ThreeState.YES;
        }
        if (right.isDirectory() && FileUtil.isAncestor((File)rightFile, (File)leftFile, (boolean)true)) {
            return ThreeState.YES;
        }
        return FileUtil.filesEqual((File)leftFile, (File)rightFile) && left.isDirectory() == right.isDirectory() ? ThreeState.YES : ThreeState.NO;
    }

    private static ThreeState comparePatterns(@NotNull UserDefinedJsonSchemaConfiguration.Item leftItem, @NotNull UserDefinedJsonSchemaConfiguration.Item rightItem) {
        if (leftItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftItem", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "comparePatterns"));
        }
        if (rightItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightItem", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "comparePatterns"));
        }
        if (leftItem.getPath().equals(rightItem.getPath())) {
            return ThreeState.YES;
        }
        BeforeAfter<String> left = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(leftItem.getPath());
        BeforeAfter<String> right = JsonSchemaPatternComparator.getBeforeAfterAroundWildCards(rightItem.getPath());
        if (left == null || right == null) {
            if (left == null && right == null) {
                return leftItem.getPath().equals(rightItem.getPath()) ? ThreeState.YES : ThreeState.NO;
            }
            if (left == null) {
                return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(leftItem, right);
            }
            return JsonSchemaPatternComparator.checkOneSideWithoutWildcard(rightItem, left);
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getBefore())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getBefore()))) {
            if (((String)left.getBefore()).startsWith((String)right.getBefore()) || ((String)right.getBefore()).startsWith((String)left.getBefore())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)left.getAfter())) && !StringUtil.isEmptyOrSpaces((String)((String)right.getAfter()))) {
            if (((String)left.getAfter()).endsWith((String)right.getAfter()) || ((String)right.getAfter()).endsWith((String)left.getAfter())) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    private static ThreeState checkOneSideWithoutWildcard(UserDefinedJsonSchemaConfiguration.Item item, BeforeAfter<String> beforeAfter) {
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getBefore())) && item.getPath().startsWith((String)beforeAfter.getBefore())) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "checkOneSideWithoutWildcard"));
            }
            return threeState;
        }
        if (!StringUtil.isEmptyOrSpaces((String)((String)beforeAfter.getAfter())) && item.getPath().endsWith((String)beforeAfter.getAfter())) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "checkOneSideWithoutWildcard"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "checkOneSideWithoutWildcard"));
        }
        return threeState;
    }

    @Nullable
    private static BeforeAfter<String> getBeforeAfterAroundWildCards(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/jsonSchema/JsonSchemaPatternComparator", "getBeforeAfterAroundWildCards"));
        }
        int firstIdx = pattern.indexOf(42);
        int lastIdx = pattern.lastIndexOf(42);
        if (firstIdx < 0 || lastIdx < 0) {
            return null;
        }
        return new BeforeAfter((Object)pattern.substring(0, firstIdx), (Object)pattern.substring(lastIdx + 1, pattern.length()));
    }
}

