/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairProcessor;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.UserDefinedJsonSchemaConfiguration;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaUserDefinedProviderFactory
implements JsonSchemaProviderFactory {
    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory", "getProviders"));
        }
        JsonSchemaMappingsProjectConfiguration configuration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
        Map<String, UserDefinedJsonSchemaConfiguration> map2 = configuration.getStateMap();
        List providers2 = map2.values().stream().map(schema -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory", "lambda$getProviders$0"));
            }
            return new MyProvider(schema.getName(), new File(project2.getBasePath(), schema.getRelativePathToSchema()), schema.getCalculatedPatterns());
        }).collect(Collectors.toList());
        List<JsonSchemaFileProvider> list2 = providers2.isEmpty() ? Collections.emptyList() : providers2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory", "getProviders"));
        }
        return list2;
    }

    static class MyProvider
    implements JsonSchemaFileProvider,
    JsonSchemaImportedProviderMarker {
        @NotNull
        private final String myName;
        @NotNull
        private final File myFile;
        private VirtualFile myVirtualFile;
        @NotNull
        private final List<PairProcessor<Project, VirtualFile>> myPatterns;

        public MyProvider(@NotNull String name2, @NotNull File file2, @NotNull List<PairProcessor<Project, VirtualFile>> patterns) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "<init>"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "<init>"));
            }
            if (patterns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "<init>"));
            }
            this.myName = name2;
            this.myFile = file2;
            this.myPatterns = patterns;
        }

        @Override
        public VirtualFile getSchemaFile() {
            if (this.myVirtualFile != null && this.myVirtualFile.isValid()) {
                return this.myVirtualFile;
            }
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            this.myVirtualFile = lfs.findFileByIoFile(this.myFile);
            if (this.myVirtualFile == null) {
                this.myVirtualFile = lfs.refreshAndFindFileByIoFile(this.myFile);
            }
            return this.myVirtualFile;
        }

        @Override
        public SchemaType getSchemaType() {
            return SchemaType.userSchema;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "getName"));
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "isAvailable"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "isAvailable"));
            }
            if (this.myPatterns.isEmpty() || file2.isDirectory() || !file2.isValid() || this.getSchemaFile() == null || JsonSchemaService.Impl.get(project2).isSchemaFile(file2)) {
                return false;
            }
            return this.myPatterns.stream().anyMatch(processor2 -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "lambda$isAvailable$0"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/extension/JsonSchemaUserDefinedProviderFactory$MyProvider", "lambda$isAvailable$0"));
                }
                return processor2.process((Object)project2, (Object)file2);
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProvider provider = (MyProvider)o;
            if (!this.myName.equals(provider.myName)) {
                return false;
            }
            return FileUtil.filesEqual((File)this.myFile, (File)provider.myFile);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + FileUtil.fileHashCode((File)this.myFile);
            return result2;
        }
    }
}

