/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.ide;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonSchemaService {
    public static boolean isSchemaFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/jsonSchema/ide/JsonSchemaService", "isSchemaFile"));
        }
        VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
        return Impl.get(psiFile.getProject()).isSchemaFile(file2);
    }

    public boolean isSchemaFile(@NotNull VirtualFile var1);

    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String var1, VirtualFile var2);

    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile var1);

    public void reset();

    public ModificationTracker getAnySchemaChangeTracker();

    @NotNull
    public static String normalizeId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/jsonSchema/ide/JsonSchemaService", "normalizeId"));
        }
        id = id.endsWith("#") ? id.substring(0, id.length() - 1) : id;
        String string = id.startsWith("#") ? id.substring(1) : id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/ide/JsonSchemaService", "normalizeId"));
        }
        return string;
    }

    public static class Impl {
        public static JsonSchemaService get(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/ide/JsonSchemaService$Impl", "get"));
            }
            return (JsonSchemaService)ServiceManager.getService((Project)project2, JsonSchemaService.class);
        }
    }
}

