/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPropertyName2SchemaDefinitionReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonPropertyName2SchemaRefReference((JsonStringLiteral)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonPropertyName2SchemaDefinitionReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JsonPropertyName2SchemaRefReference
    extends JsonSchemaBaseReference<JsonStringLiteral> {
        public JsonPropertyName2SchemaRefReference(JsonStringLiteral element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            JsonSchemaService service = JsonSchemaService.Impl.get(((JsonStringLiteral)this.myElement).getProject());
            VirtualFile file2 = ((JsonStringLiteral)this.myElement).getContainingFile().getVirtualFile();
            if (file2 == null) {
                return null;
            }
            List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonOriginalPsiWalker.INSTANCE.findPosition(this.getElement(), true, true);
            if (steps == null) {
                return null;
            }
            JsonSchemaObject schemaObject = service.getSchemaObject(file2);
            if (schemaObject != null) {
                return new JsonSchemaResolver(schemaObject, true, steps).findNavigationTarget(false, JsonSchemaService.isSchemaFile(((JsonStringLiteral)this.myElement).getContainingFile()));
            }
            return null;
        }
    }
}

