/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaAnnotator
implements Annotator {
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES = Key.create((String)"JsonSchema.Properties.Annotated");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator", "annotate"));
        }
        if (element.getContainingFile() == null) {
            return;
        }
        JsonSchemaObject rootSchema = JsonSchemaService.Impl.get(element.getProject()).getSchemaObject(element.getContainingFile().getViewProvider().getVirtualFile());
        if (rootSchema == null) {
            return;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, rootSchema);
        if (walker == null) {
            return;
        }
        new Worker(rootSchema, holder, walker).annotate(element);
    }

    public static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final AnnotationHolder myHolder;
        @NotNull
        private final JsonLikePsiWalker myWalker;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull AnnotationHolder holder, @NotNull JsonLikePsiWalker walker) {
            if (rootSchema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "<init>"));
            }
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "<init>"));
            }
            if (walker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "<init>"));
            }
            this.myRootSchema = rootSchema;
            this.myHolder = holder;
            this.myWalker = walker;
        }

        public void annotate(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "annotate"));
            }
            JsonPropertyAdapter firstProp = this.myWalker.getParentPropertyAdapter(element);
            if (firstProp != null && firstProp.getValue() != null) {
                List<JsonSchemaVariantsTreeBuilder.Step> position = this.myWalker.findPosition(firstProp.getDelegate(), false, true);
                if (position == null || position.isEmpty()) {
                    return;
                }
                MatchResult result2 = new JsonSchemaResolver(this.myRootSchema, false, position).detailedResolve();
                this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(firstProp.getValue(), result2));
            }
            this.checkRoot(element, firstProp);
        }

        private void checkRoot(@NotNull PsiElement element, JsonPropertyAdapter firstProp) {
            JsonValueAdapter rootToCheck;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "checkRoot"));
            }
            if (firstProp == null) {
                rootToCheck = Worker.findTopLevelElement(this.myWalker, element);
            } else {
                rootToCheck = firstProp.getParentObject();
                if (rootToCheck == null) {
                    rootToCheck = firstProp.getParentArray();
                }
                if (rootToCheck == null || !this.myWalker.isTopJsonElement(rootToCheck.getDelegate().getParent())) {
                    return;
                }
            }
            if (rootToCheck != null) {
                MatchResult matchResult = new JsonSchemaResolver(this.myRootSchema).detailedResolve();
                this.createWarnings(JsonSchemaAnnotatorChecker.checkByMatchResult(rootToCheck, matchResult));
            }
        }

        private void createWarnings(@Nullable JsonSchemaAnnotatorChecker checker) {
            if (checker != null && !checker.isCorrect()) {
                for (Map.Entry<PsiElement, String> entry : checker.getErrors().entrySet()) {
                    if (Worker.checkIfAlreadyProcessed(this.myHolder, entry.getKey())) continue;
                    this.myHolder.createWarningAnnotation(entry.getKey(), entry.getValue());
                }
            }
        }

        private static JsonValueAdapter findTopLevelElement(@NotNull JsonLikePsiWalker walker, @NotNull PsiElement element) {
            if (walker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "findTopLevelElement"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "findTopLevelElement"));
            }
            Ref ref = new Ref();
            PsiTreeUtil.findFirstParent((PsiElement)element, el -> {
                if (walker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "walker", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "lambda$findTopLevelElement$0"));
                }
                boolean isTop = walker.isTopJsonElement((PsiElement)el);
                if (!isTop) {
                    ref.set(el);
                }
                return isTop;
            });
            return ref.isNull() ? null : walker.createValueAdapter((PsiElement)ref.get());
        }

        private static boolean checkIfAlreadyProcessed(@NotNull AnnotationHolder holder, PsiElement property) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotator$Worker", "checkIfAlreadyProcessed"));
            }
            AnnotationSession session2 = holder.getCurrentAnnotationSession();
            HashSet<PsiElement> data = (HashSet<PsiElement>)session2.getUserData(ANNOTATED_PROPERTIES);
            if (data == null) {
                data = new HashSet<PsiElement>();
                session2.putUserData(ANNOTATED_PROPERTIES, data);
            }
            if (data.contains(property)) {
                return true;
            }
            data.add(property);
            return false;
        }
    }
}

