/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.google.common.base.Predicates;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaAnnotatorChecker {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, String> myErrors = new HashMap<PsiElement, String>();
    private boolean myHadTypeError;

    private JsonSchemaAnnotatorChecker() {
    }

    public Map<PsiElement, String> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result2) {
        if (elementToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCheck", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkByMatchResult"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkByMatchResult"));
        }
        ArrayList<Object> checkers = new ArrayList<Object>();
        if (result2.myExcludingSchemas.isEmpty() && result2.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker();
            checker2.checkByScheme(elementToCheck, result2.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result2.mySchemas.isEmpty()) {
                checkers.add(JsonSchemaAnnotatorChecker.processSchemasVariants(result2.mySchemas, elementToCheck, false).getSecond());
            }
            if (!result2.myExcludingSchemas.isEmpty()) {
                SmartList selectedSchemas = new SmartList();
                List<JsonSchemaAnnotatorChecker> list2 = result2.myExcludingSchemas.stream().map(arg_0 -> JsonSchemaAnnotatorChecker.lambda$checkByMatchResult$0(elementToCheck, (List)selectedSchemas, arg_0)).collect(Collectors.toList());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(list2, (List<JsonSchemaObject>)selectedSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull List<JsonSchemaAnnotatorChecker> list2, @NotNull List<JsonSchemaObject> selectedSchemas) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "mergeErrors"));
        }
        if (selectedSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedSchemas", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "mergeErrors"));
        }
        Set skipErrors = selectedSchemas.stream().filter(Predicates.notNull()).map(schema -> schema.getProperties().keySet()).flatMap(Collection::stream).map(name2 -> JsonBundle.message("json.schema.annotation.not.allowed.property", name2)).collect(Collectors.toSet());
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
        list2.stream().map(ch -> {
            Map<PsiElement, String> map2 = ch.myErrors;
            List<PsiElement> toRemove2 = map2.keySet().stream().filter(key2 -> skipErrors.contains(map2.get(key2))).collect(Collectors.toList());
            toRemove2.forEach(map2::remove);
            return map2;
        }).forEach(map2 -> checker.myErrors.putAll((Map<PsiElement, String>)map2));
        return checker;
    }

    private void error(String error, PsiElement holder) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, error);
    }

    private void typeError(@NotNull PsiElement value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "typeError"));
        }
        this.error("Type is not allowed", value2);
        this.myHadTypeError = true;
    }

    private void checkByScheme(@NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkByScheme"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkByScheme"));
        }
        JsonSchemaType type2 = JsonSchemaType.getType(value2);
        if (type2 != null) {
            JsonSchemaType schemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type2);
            if (schemaType != null && !schemaType.equals((Object)type2)) {
                this.typeError(value2.getDelegate());
            } else if (JsonSchemaType._boolean.equals((Object)type2)) {
                this.checkForEnum(value2.getDelegate(), schema);
            } else if (JsonSchemaType._number.equals((Object)type2) || JsonSchemaType._integer.equals((Object)type2)) {
                this.checkNumber(value2.getDelegate(), schema, type2);
                this.checkForEnum(value2.getDelegate(), schema);
            } else if (JsonSchemaType._string.equals((Object)type2)) {
                this.checkString(value2.getDelegate(), schema);
                this.checkForEnum(value2.getDelegate(), schema);
            } else if (JsonSchemaType._array.equals((Object)type2)) {
                this.checkArray(value2, schema);
                this.checkForEnum(value2.getDelegate(), schema);
            } else if (JsonSchemaType._object.equals((Object)type2)) {
                this.checkObject(value2, schema);
                this.checkForEnum(value2.getDelegate(), schema);
            }
        }
        if (schema.getNot() != null) {
            MatchResult result2 = new JsonSchemaResolver(schema.getNot()).detailedResolve();
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            if (result2.mySchemas.stream().anyMatch(s -> {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "lambda$checkByScheme$7"));
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            }) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> {
                if (schema == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "lambda$checkByScheme$8"));
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            })) {
                return;
            }
            JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(value2, result2);
            if (checker == null || checker.isCorrect()) {
                this.error("Validates against 'not' schema", value2.getDelegate());
            }
        }
    }

    private void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkObjectBySchemaRecordErrors"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkObjectBySchemaRecordErrors"));
        }
        JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(object, new JsonSchemaResolver(schema).detailedResolve());
        if (checker != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    private void checkObject(@NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkObject"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkObject"));
        }
        JsonObjectValueAdapter object = value2.getAsObject();
        if (object == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set2 = new HashSet<String>();
        for (JsonPropertyAdapter jsonPropertyAdapter : propertyList) {
            String string = StringUtil.notNullize((String)jsonPropertyAdapter.getName());
            JsonSchemaVariantsTreeBuilder.Step step = JsonSchemaVariantsTreeBuilder.Step.createPropertyStep(string);
            Pair<ThreeState, JsonSchemaObject> pair2 = step.step(schema, true);
            if (ThreeState.NO.equals(pair2.getFirst()) && !set2.contains(string)) {
                this.error(JsonBundle.message("json.schema.annotation.not.allowed.property", string), jsonPropertyAdapter.getDelegate());
            } else if (ThreeState.UNSURE.equals(pair2.getFirst()) && jsonPropertyAdapter.getValue() != null) {
                this.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair2.getSecond(), jsonPropertyAdapter.getValue());
            }
            set2.add(string);
        }
        if (object.shouldCheckIntegralRequirements()) {
            Map<String, JsonSchemaObject> map2;
            Map<String, List<String>> map3;
            List<String> required = schema.getRequired();
            if (required != null) {
                for (String string : required) {
                    if (set2.contains(string)) continue;
                    this.error("Missing required property '" + string + "'", value2.getDelegate());
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                this.error("Number of properties is less than " + schema.getMinProperties(), value2.getDelegate());
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                this.error("Number of properties is greater than " + schema.getMaxProperties(), value2.getDelegate());
            }
            if ((map3 = schema.getPropertyDependencies()) != null) {
                for (Map.Entry<String, List<String>> entry : map3.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    List<String> list2 = entry.getValue();
                    for (String s : list2) {
                        if (set2.contains(s)) continue;
                        this.error("Dependency is violated: '" + s + "' must be specified, since '" + entry.getKey() + "' is specified", value2.getDelegate());
                    }
                }
            }
            if ((map2 = schema.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry : map2.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    this.checkObjectBySchemaRecordErrors(entry.getValue(), value2);
                }
            }
        }
        this.validateAsJsonSchema(object.getDelegate());
    }

    private void validateAsJsonSchema(@NotNull PsiElement objElement) {
        if (objElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objElement", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "validateAsJsonSchema"));
        }
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)objElement, JsonObject.class);
        if (object == null) {
            return;
        }
        if (JsonSchemaService.isSchemaFile(objElement.getContainingFile())) {
            VirtualFile schemaFile = object.getContainingFile().getVirtualFile();
            if (schemaFile == null) {
                return;
            }
            JsonSchemaObject schemaObject = JsonSchemaService.Impl.get(object.getProject()).getSchemaObjectForSchemaFile(schemaFile);
            if (schemaObject == null) {
                return;
            }
            List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonSchemaAnnotatorChecker.skipProperties(JsonOriginalPsiWalker.INSTANCE.findPosition(object, false, true));
            MatchResult result2 = new JsonSchemaResolver(schemaObject, false, steps).detailedResolve();
            ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(result2.mySchemas);
            schemas.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            schemas.forEach(schema -> {
                if (schemaFile.equals(schema.getSchemaFile())) {
                    Map<JsonObject, String> invalidPatternProperties = schema.getInvalidPatternProperties();
                    if (invalidPatternProperties != null) {
                        for (Map.Entry<JsonObject, String> entry : invalidPatternProperties.entrySet()) {
                            PsiElement parent;
                            JsonObject element = entry.getKey();
                            if (element == null || !element.isValid() || !((parent = element.getParent()) instanceof JsonProperty)) continue;
                            this.error(StringUtil.convertLineSeparators((String)entry.getValue()), ((JsonProperty)parent).getNameElement());
                        }
                    }
                    schema.getProperties().values().forEach(prop -> {
                        JsonProperty pattern;
                        JsonObject element;
                        String patternError = prop.getPatternError();
                        if (patternError != null && prop.getPattern() != null && (element = prop.getJsonObject()).isValid() && (pattern = element.findProperty("pattern")) != null) {
                            this.error(StringUtil.convertLineSeparators((String)patternError), pattern.getValue());
                        }
                    });
                }
            });
        }
    }

    private static List<JsonSchemaVariantsTreeBuilder.Step> skipProperties(List<JsonSchemaVariantsTreeBuilder.Step> position) {
        Iterator<JsonSchemaVariantsTreeBuilder.Step> iterator = position.iterator();
        boolean canSkip = true;
        while (iterator.hasNext()) {
            JsonSchemaVariantsTreeBuilder.Step step = iterator.next();
            if (canSkip && step.isFromObject() && "properties".equals(step.getName())) {
                iterator.remove();
                canSkip = false;
                continue;
            }
            canSkip = true;
        }
        return position;
    }

    private void checkForEnum(PsiElement value2, JsonSchemaObject schema) {
        if (schema.getEnum() == null || schema.getPattern() != null) {
            return;
        }
        String text2 = StringUtil.notNullize((String)value2.getText());
        List<Object> objects = schema.getEnum();
        for (Object object : objects) {
            if (!(JsonLikePsiWalker.getWalker(value2, schema).onlyDoubleQuotesForStringLiterals() ? object.toString().equalsIgnoreCase(text2) : JsonSchemaAnnotatorChecker.equalsIgnoreQuotesAndCase(object.toString(), text2))) continue;
            return;
        }
        this.error("Value should be one of: [" + StringUtil.join(objects, o -> o.toString(), (String)", ") + "]", value2);
    }

    private static boolean equalsIgnoreQuotesAndCase(@NotNull String s1, @NotNull String s2) {
        boolean quoted2;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "equalsIgnoreQuotesAndCase"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "equalsIgnoreQuotesAndCase"));
        }
        boolean quoted1 = StringUtil.isQuotedString((String)s1);
        if (quoted1 != (quoted2 = StringUtil.isQuotedString((String)s2))) {
            return false;
        }
        if (!quoted1) {
            return s1.equalsIgnoreCase(s2);
        }
        return StringUtil.unquoteString((String)s1).equalsIgnoreCase(StringUtil.unquoteString((String)s2));
    }

    private void checkArray(JsonValueAdapter value2, JsonSchemaObject schema) {
        JsonArrayValueAdapter asArray = value2.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        if (schema.getMinLength() != null && elements.size() < schema.getMinLength()) {
            this.error("Array is shorter than " + schema.getMinLength(), value2.getDelegate());
            return;
        }
        this.checkArrayItems(value2, elements, schema);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Collection<JsonSchemaObject> collection, @NotNull JsonValueAdapter value2, boolean isOneOf) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "processSchemasVariants"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "processSchemasVariants"));
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
        JsonSchemaType type2 = JsonSchemaType.getType(value2);
        JsonSchemaObject selected = null;
        if (type2 == null) {
            if (!value2.isShouldBeIgnored()) {
                checker.typeError(value2.getDelegate());
            }
        } else {
            List<JsonSchemaObject> filtered = collection.stream().filter(schema -> JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema, type2)).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                checker.typeError(value2.getDelegate());
            } else {
                selected = isOneOf ? checker.processOneOf(value2, filtered) : checker.processAnyOf(value2, filtered);
            }
        }
        Pair pair2 = Pair.create(selected, (Object)checker);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "processSchemasVariants"));
        }
        return pair2;
    }

    private static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type2) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "areSchemaTypesCompatible"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "areSchemaTypesCompatible"));
        }
        JsonSchemaType matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type2);
        if (matchingSchemaType != null) {
            return matchingSchemaType.equals((Object)type2);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type2);
        }
        return true;
    }

    @Nullable
    private static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "getMatchingSchemaType"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "getMatchingSchemaType"));
        }
        if (schema.getType() != null && (matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            List<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            return matchTypes.get(0);
        }
        if (!schema.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkArrayItems"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkArrayItems"));
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            list2.forEach(item -> valueTexts.putValue((Object)item.getDelegate().getText(), item));
            valueTexts.keySet().stream().filter(key2 -> valueTexts.get(key2).size() > 1).map(key2 -> valueTexts.get(key2)).flatMap(Collection::stream).forEach(item -> this.error("Item is not unique", item.getDelegate()));
        }
        if (schema.getItemsSchema() != null) {
            list2.forEach(item -> this.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), (JsonValueAdapter)item));
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    this.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) continue;
                this.error("Additional items are not allowed", arrayValue.getDelegate());
            }
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            this.error("Array is shorter than " + schema.getMinItems(), array.getDelegate());
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            this.error("Array is longer than " + schema.getMaxItems(), array.getDelegate());
        }
    }

    private void checkString(PsiElement propValue, JsonSchemaObject schema) {
        String value2 = StringUtil.unquoteString((String)propValue.getText());
        if (schema.getMinLength() != null && value2.length() < schema.getMinLength()) {
            this.error("String is shorter than " + schema.getMinLength(), propValue);
            return;
        }
        if (schema.getMaxLength() != null && value2.length() > schema.getMaxLength()) {
            this.error("String is longer than " + schema.getMaxLength(), propValue);
            return;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                this.error("Can not check string by pattern because of error: " + StringUtil.convertLineSeparators((String)schema.getPatternError()), propValue);
            }
            if (!schema.checkByPattern(value2)) {
                this.error("String is violating the pattern: '" + StringUtil.convertLineSeparators((String)schema.getPattern()) + "'", propValue);
            }
        }
    }

    private void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
        double leftOver;
        Number value2;
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            try {
                value2 = Integer.valueOf(propValue.getText());
            }
            catch (NumberFormatException e) {
                this.error("Integer value expected", propValue);
                return;
            }
        }
        try {
            value2 = Double.valueOf(propValue.getText());
        }
        catch (NumberFormatException e) {
            this.error("Double value expected", propValue);
            return;
        }
        Number multipleOf = schema.getMultipleOf();
        if (multipleOf != null && (leftOver = value2.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            this.error("Is not multiple of " + multipleOfValue, propValue);
            return;
        }
        if (schema.getMinimum() != null) {
            this.checkMinimum(schema, value2, propValue, schemaType);
        }
        if (schema.getMaximum() != null) {
            this.checkMaximum(schema, value2, propValue, schemaType);
        }
    }

    private void checkMaximum(JsonSchemaObject schema, Number value2, PsiElement propertyValue, @NotNull JsonSchemaType propValueType) {
        if (propValueType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propValueType", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkMaximum"));
        }
        if (JsonSchemaType._integer.equals((Object)propValueType)) {
            int intValue = schema.getMaximum().intValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                if (value2.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue);
                }
            } else if (value2.intValue() > intValue) {
                this.error("Greater than a maximum " + intValue, propertyValue);
            }
        } else {
            double doubleValue = schema.getMaximum().doubleValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                if (value2.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + schema.getMinimum(), propertyValue);
                }
            } else if (value2.doubleValue() > doubleValue) {
                this.error("Greater than a maximum " + schema.getMaximum(), propertyValue);
            }
        }
    }

    private void checkMinimum(JsonSchemaObject schema, Number value2, PsiElement propertyValue, @NotNull JsonSchemaType schemaType) {
        if (schemaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaType", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "checkMinimum"));
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            int intValue = schema.getMinimum().intValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                if (value2.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum " + intValue, propertyValue);
                }
            } else if (value2.intValue() < intValue) {
                this.error("Less than a minimum " + intValue, propertyValue);
            }
        } else {
            double doubleValue = schema.getMinimum().doubleValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                if (value2.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + schema.getMinimum(), propertyValue);
                }
            } else if (value2.doubleValue() < doubleValue) {
                this.error("Less than a minimum " + schema.getMinimum(), propertyValue);
            }
        }
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value2, List<JsonSchemaObject> oneOf) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "processOneOf"));
        }
        HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
        boolean wasTypeError = false;
        SmartList correct = new SmartList();
        JsonSchemaObject current = null;
        for (JsonSchemaObject jsonSchemaObject : oneOf) {
            if (jsonSchemaObject.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
            checker.checkByScheme(value2, jsonSchemaObject);
            if (checker.isCorrect()) {
                current = jsonSchemaObject;
                errors.clear();
                correct.add(jsonSchemaObject);
                continue;
            }
            if (!errors.isEmpty() && (!wasTypeError || checker.isHadTypeError()) && errors.size() <= checker.getErrors().size()) continue;
            wasTypeError = checker.isHadTypeError();
            current = jsonSchemaObject;
            errors.clear();
            errors.putAll(checker.getErrors());
        }
        if (correct.size() == 1) {
            return current;
        }
        if (correct.size() > 0) {
            JsonSchemaType type2 = JsonSchemaType.getType(value2);
            if (type2 != null && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error("Validates to more than one variant", value2.getDelegate());
            }
        } else if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                this.error((String)entry.getValue(), (PsiElement)entry.getKey());
            }
        }
        return current;
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "schemesDifferWithNotCheckedProperties"));
        }
        return list2.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value2, List<JsonSchemaObject> anyOf) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "processAnyOf"));
        }
        HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
        JsonSchemaObject current = null;
        for (JsonSchemaObject jsonSchemaObject : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
            checker.checkByScheme(value2, jsonSchemaObject);
            if (checker.isCorrect()) {
                return jsonSchemaObject;
            }
            if (!errors.isEmpty() || checker.isHadTypeError()) continue;
            current = jsonSchemaObject;
            errors.clear();
            errors.putAll(checker.getErrors());
        }
        if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                this.error((String)entry.getValue(), (PsiElement)entry.getKey());
            }
        }
        return current;
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ JsonSchemaAnnotatorChecker lambda$checkByMatchResult$0(@NotNull JsonValueAdapter elementToCheck, List selectedSchemas, Set group) {
        if (elementToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToCheck", "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker", "lambda$checkByMatchResult$0"));
        }
        Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> pair2 = JsonSchemaAnnotatorChecker.processSchemasVariants(group, elementToCheck, true);
        if (pair2.getFirst() != null) {
            selectedSchemas.add(pair2.getFirst());
        }
        return (JsonSchemaAnnotatorChecker)pair2.getSecond();
    }
}

