/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurable;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaConflictNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"json.schema.conflict.notification.panel");
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaService myJsonSchemaService;

    public JsonSchemaConflictNotificationProvider(@NotNull Project project2, @NotNull JsonSchemaService jsonSchemaService) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "<init>"));
        }
        if (jsonSchemaService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaService", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "<init>"));
        }
        this.myProject = project2;
        this.myJsonSchemaService = jsonSchemaService;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key2 = KEY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "getKey"));
        }
        return key2;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "createNotificationPanel"));
        }
        Collection<VirtualFile> schemaFiles = this.myJsonSchemaService.getSchemaFilesForFile(file2);
        if (schemaFiles.size() <= 1) {
            return null;
        }
        String message2 = this.createMessage(schemaFiles);
        if (message2 == null) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(LightColors.RED);
        panel2.setText(message2);
        panel2.createActionLabel("Edit JSON Schema Mappings", () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "lambda$createNotificationPanel$0"));
            }
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new JsonSchemaMappingsConfigurable(this.myProject));
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file2);
        });
        return panel2;
    }

    public String createMessage(@NotNull Collection<VirtualFile> schemaFiles) {
        if (schemaFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFiles", "com/jetbrains/jsonSchema/impl/JsonSchemaConflictNotificationProvider", "createMessage"));
        }
        List pairList = schemaFiles.stream().map(file2 -> this.myJsonSchemaService.getSchemaProvider((VirtualFile)file2)).filter(Objects::nonNull).map(provider -> Pair.create((Object)SchemaType.userSchema.equals((Object)provider.getSchemaType()), (Object)provider.getName())).collect(Collectors.toList());
        long numOfSystemSchemas = pairList.stream().filter(pair2 -> (Boolean)pair2.getFirst() == false).count();
        if (pairList.size() == 2 && numOfSystemSchemas == 1L) {
            return null;
        }
        boolean withTypes = numOfSystemSchemas > 0L;
        return pairList.stream().map(pair2 -> {
            if (withTypes) {
                return String.format("%s schema '%s'", Boolean.TRUE.equals(pair2.getFirst()) ? "user" : "system", pair2.getSecond());
            }
            return (String)pair2.getSecond();
        }).collect(Collectors.joining("; ", "<html>There are several JSON Schemas mapped to this file: ", "</html>"));
    }
}

