/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, originalElement, false);
    }

    @Nullable
    private static String findSchemaAndGenerateDoc(PsiElement element, @Nullable PsiElement originalElement, boolean preferShort) {
        PsiFile containingFile = (element = (PsiElement)ObjectUtils.coalesce((Object)originalElement, (Object)element)).getContainingFile();
        if (containingFile == null) {
            return null;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(element.getProject());
        JsonSchemaObject rootSchema = service.getSchemaObject(containingFile.getViewProvider().getVirtualFile());
        if (rootSchema == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc(element, rootSchema, preferShort);
    }

    @Nullable
    public static String generateDoc(@NotNull PsiElement element, @NotNull JsonSchemaObject rootSchema, boolean preferShort) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider", "generateDoc"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaDocumentationProvider", "generateDoc"));
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, rootSchema);
        if (walker == null) {
            return null;
        }
        PsiElement checkable = walker.goUpToCheckable(element);
        if (checkable == null) {
            return null;
        }
        List<JsonSchemaVariantsTreeBuilder.Step> position = walker.findPosition(checkable, true, true);
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(rootSchema, true, position).resolve();
        return StringUtil.escapeXml((String)schemas.stream().filter(schema -> !StringUtil.isEmptyOrSpaces((String)schema.getDocumentation(preferShort))).findFirst().map(schema -> schema.getDocumentation(preferShort)).orElse(null));
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

