/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNullLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = 0x100000;
    public static final Logger LOG = Logger.getInstance(JsonSchemaReader.class);
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");
    private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
    private final ArrayDeque<JsonSchemaObject> myQueue = new ArrayDeque();
    private static final Map<String, MyReader> READERS_MAP = new HashMap<String, MyReader>();

    public static JsonSchemaObject readFromFile(@NotNull Project project2, @NotNull VirtualFile key2) throws Exception {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readFromFile"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readFromFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(key2);
        if (!(psiFile instanceof JsonFile)) {
            throw new Exception(String.format("Can not load PSI for JSON Schema file '%s'", key2.getName()));
        }
        JsonObject value2 = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
        if (value2 == null) {
            throw new Exception(String.format("JSON Schema file '%s' must contain only one top-level object", key2.getName()));
        }
        return new JsonSchemaReader().read(value2);
    }

    @Nullable
    public static String checkIfValidJsonSchema(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "checkIfValidJsonSchema"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "checkIfValidJsonSchema"));
        }
        long length = file2.getLength();
        String fileName = file2.getName();
        if (length > 0x100000L) {
            return String.format("JSON schema was not loaded from '%s' because it's too large (file size is %d bytes).", fileName, length);
        }
        if (length == 0L) {
            return String.format("JSON schema was not loaded from '%s'. File is empty.", fileName);
        }
        try {
            JsonSchemaReader.readFromFile(project2, file2);
        }
        catch (Exception e) {
            String message2 = String.format("JSON Schema not found or contain error in '%s': %s", fileName, e.getMessage());
            LOG.info(message2);
            return message2;
        }
        return null;
    }

    @Nullable
    public static String readSchemaId(@NotNull Project project2, @NotNull VirtualFile schemaFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readSchemaId"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readSchemaId"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(schemaFile);
        if (psiFile == null || !(psiFile instanceof JsonFile)) {
            return null;
        }
        CachedValueProvider provider = () -> {
            JsonObject topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
            if (topLevelValue == null) {
                return null;
            }
            return CachedValueProvider.Result.create((Object)JsonSchemaReader.readId(topLevelValue), (Object[])new Object[]{psiFile});
        };
        return (String)ReadAction.compute(() -> (String)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider));
    }

    public JsonSchemaObject read(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "read"));
        }
        JsonSchemaObject root = new JsonSchemaObject(object);
        this.myQueue.add(root);
        while (!this.myQueue.isEmpty()) {
            JsonSchemaObject currentSchema = this.myQueue.removeFirst();
            JsonObject jsonObject = currentSchema.getJsonObject();
            List<JsonProperty> list2 = jsonObject.getPropertyList();
            for (JsonProperty property : list2) {
                if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                MyReader reader = READERS_MAP.get(property.getName());
                if (reader != null) {
                    reader.read(property.getValue(), currentSchema, this.myQueue);
                    continue;
                }
                this.readSingleDefinition(property.getName(), property.getValue(), currentSchema);
            }
            if (currentSchema.getId() == null) continue;
            this.myIds.put(currentSchema.getId(), currentSchema);
        }
        return root;
    }

    public Map<String, JsonSchemaObject> getIds() {
        return this.myIds;
    }

    @Nullable
    private static String readId(@NotNull JsonObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readId"));
        }
        JsonProperty property = object.findProperty("id");
        if (property != null && property.getValue() instanceof JsonStringLiteral) {
            return JsonSchemaService.normalizeId(StringUtil.unquoteString((String)property.getValue().getText()));
        }
        return null;
    }

    private void readSingleDefinition(@NotNull String name2, @NotNull JsonValue value2, @NotNull JsonSchemaObject schema) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readSingleDefinition"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readSingleDefinition"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readSingleDefinition"));
        }
        if (value2 instanceof JsonObject) {
            JsonSchemaObject defined = new JsonSchemaObject((JsonObject)value2);
            this.myQueue.add(defined);
            Map<String, JsonSchemaObject> definitions = schema.getDefinitionsMap();
            if (definitions == null) {
                definitions = new HashMap<String, JsonSchemaObject>();
                schema.setDefinitionsMap(definitions);
            }
            definitions.put(name2, defined);
        }
    }

    private static void fillMap() {
        READERS_MAP.put("id", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setId(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("$schema", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setSchema(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("description", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setDescription(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("title", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setTitle(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("$ref", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setRef(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("default", JsonSchemaReader.createDefault());
        READERS_MAP.put("format", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setFormat(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("definitions", JsonSchemaReader.createDefinitionsConsumer());
        READERS_MAP.put("properties", JsonSchemaReader.createPropertiesConsumer());
        READERS_MAP.put("multipleOf", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMultipleOf(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maximum", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaximum(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minimum", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinimum(((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("exclusiveMaximum", (element, object, queue) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMaximum(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("exclusiveMinimum", (element, object, queue) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setExclusiveMinimum(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maxLength", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxLength((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minLength", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinLength((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("pattern", (element, object, queue) -> {
            if (element instanceof JsonStringLiteral) {
                object.setPattern(StringUtil.unquoteString((String)element.getText()));
            }
        });
        READERS_MAP.put("additionalItems", JsonSchemaReader.createAdditionalItems());
        READERS_MAP.put("items", JsonSchemaReader.createItems());
        READERS_MAP.put("maxItems", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxItems((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minItems", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinItems((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("uniqueItems", (element, object, queue) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setUniqueItems(((JsonBooleanLiteral)element).getValue());
            }
        });
        READERS_MAP.put("maxProperties", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMaxProperties((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("minProperties", (element, object, queue) -> {
            if (element instanceof JsonNumberLiteral) {
                object.setMinProperties((int)((JsonNumberLiteral)element).getValue());
            }
        });
        READERS_MAP.put("required", JsonSchemaReader.createRequired());
        READERS_MAP.put("additionalProperties", JsonSchemaReader.createAdditionalProperties());
        READERS_MAP.put("patternProperties", JsonSchemaReader.createPatternProperties());
        READERS_MAP.put("dependencies", JsonSchemaReader.createDependencies());
        READERS_MAP.put("enum", JsonSchemaReader.createEnum());
        READERS_MAP.put("type", JsonSchemaReader.createType());
        READERS_MAP.put("allOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("anyOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("oneOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("not", JsonSchemaReader.createNot());
        READERS_MAP.put("instanceof", (element, object, queue) -> object.shouldValidateAgainstJSType());
        READERS_MAP.put("typeof", (element, object, queue) -> object.shouldValidateAgainstJSType());
    }

    private static MyReader createNot() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject not = new JsonSchemaObject((JsonObject)element);
                queue.add(not);
                object.setNot(not);
            }
        };
    }

    private static MyReader createContainer(@NotNull PairConsumer<JsonSchemaObject, List<JsonSchemaObject>> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "createContainer"));
        }
        return (element, object, queue) -> {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "lambda$createContainer$29"));
            }
            if (element instanceof JsonArray) {
                List<JsonValue> list2 = ((JsonArray)element).getValueList();
                List members = list2.stream().filter(el -> el instanceof JsonObject).map(el -> {
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)el);
                    queue.add(child);
                    return child;
                }).collect(Collectors.toList());
                delegate.consume((Object)object, members);
            }
        };
    }

    private static MyReader createType() {
        return (element, object, queue) -> {
            List<JsonSchemaType> typeList;
            if (element instanceof JsonStringLiteral) {
                JsonSchemaType type2 = JsonSchemaReader.parseType(StringUtil.unquoteString((String)element.getText()));
                if (type2 != null) {
                    object.setType(type2);
                }
            } else if (element instanceof JsonArray && !(typeList = ((JsonArray)element).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> JsonSchemaReader.parseType(StringUtil.unquoteString((String)el.getText()))).filter(el -> el != null).collect(Collectors.toList())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    private static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "parseType"));
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static MyReader createEnum() {
        return (element, object, queue) -> {
            if (element instanceof JsonArray) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValue> list2 = ((JsonArray)element).getValueList();
                for (JsonValue value2 : list2) {
                    if (value2 instanceof JsonStringLiteral) {
                        objects.add("\"" + StringUtil.unquoteString((String)((JsonStringLiteral)value2).getValue()) + "\"");
                        continue;
                    }
                    if (value2 instanceof JsonNumberLiteral) {
                        objects.add(JsonSchemaReader.getNumber((JsonNumberLiteral)value2));
                        continue;
                    }
                    if (value2 instanceof JsonBooleanLiteral) {
                        objects.add(((JsonBooleanLiteral)value2).getValue());
                        continue;
                    }
                    if (!(value2 instanceof JsonNullLiteral)) continue;
                    objects.add("null");
                }
                object.setEnum(objects);
            }
        };
    }

    @NotNull
    private static Number getNumber(@NotNull JsonNumberLiteral value2) {
        Number numberValue;
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "getNumber"));
        }
        try {
            numberValue = Integer.parseInt(value2.getText());
        }
        catch (NumberFormatException e) {
            numberValue = value2.getValue();
        }
        Number number = numberValue;
        if (number == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "getNumber"));
        }
        return number;
    }

    private static MyReader createDependencies() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                List<JsonProperty> list2 = ((JsonObject)element).getPropertyList();
                for (JsonProperty property : list2) {
                    if (StringUtil.isEmptyOrSpaces((String)property.getName()) || property.getValue() == null) continue;
                    if (property.getValue() instanceof JsonArray) {
                        List dependencies = ((JsonArray)property.getValue()).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList());
                        if (dependencies.isEmpty()) continue;
                        propertyDependencies.put(property.getName(), dependencies);
                        continue;
                    }
                    if (!(property.getValue() instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
                    queue.add(child);
                    schemaDependencies.put(property.getName(), child);
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValue> notEmptyString() {
        Predicate<JsonValue> predicate = el -> el instanceof JsonStringLiteral && !StringUtil.isEmptyOrSpaces((String)el.getText());
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "notEmptyString"));
        }
        return predicate;
    }

    private static MyReader createPatternProperties() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                object.setPatternProperties(JsonSchemaReader.readInnerObject((JsonObject)element, queue));
            }
        };
    }

    private static MyReader createAdditionalProperties() {
        return (element, object, queue) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalPropertiesAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                queue.add(schema);
                object.setAdditionalPropertiesSchema(schema);
            }
        };
    }

    private static MyReader createRequired() {
        return (element, object, queue) -> {
            if (element instanceof JsonArray) {
                object.setRequired(((JsonArray)element).getValueList().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getText())).collect(Collectors.toList()));
            }
        };
    }

    private static MyReader createItems() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schema = new JsonSchemaObject((JsonObject)element);
                queue.add(schema);
                object.setItemsSchema(schema);
            } else if (element instanceof JsonArray) {
                ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>();
                List<JsonValue> values = ((JsonArray)element).getValueList();
                for (JsonValue value2 : values) {
                    if (!(value2 instanceof JsonObject)) continue;
                    JsonSchemaObject child = new JsonSchemaObject((JsonObject)value2);
                    queue.add(child);
                    list2.add(child);
                }
                object.setItemsSchemaList(list2);
            }
        };
    }

    private static MyReader createAdditionalItems() {
        return (element, object, queue) -> {
            if (element instanceof JsonBooleanLiteral) {
                object.setAdditionalItemsAllowed(((JsonBooleanLiteral)element).getValue());
            } else if (element instanceof JsonObject) {
                JsonSchemaObject additionalItemsSchema = new JsonSchemaObject((JsonObject)element);
                queue.add(additionalItemsSchema);
                object.setAdditionalItemsSchema(additionalItemsSchema);
            }
        };
    }

    private static MyReader createPropertiesConsumer() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                object.setProperties(JsonSchemaReader.readInnerObject((JsonObject)element, queue));
            }
        };
    }

    private static MyReader createDefinitionsConsumer() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                JsonObject definitions = (JsonObject)element;
                object.setDefinitionsMap(JsonSchemaReader.readInnerObject(definitions, queue));
                object.setDefinitions(definitions);
            }
        };
    }

    @NotNull
    private static Map<String, JsonSchemaObject> readInnerObject(@NotNull JsonObject element, @NotNull Collection<JsonSchemaObject> queue) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readInnerObject"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readInnerObject"));
        }
        List<JsonProperty> properties = element.getPropertyList();
        HashMap<String, JsonSchemaObject> map2 = new HashMap<String, JsonSchemaObject>();
        for (JsonProperty property : properties) {
            if (StringUtil.isEmptyOrSpaces((String)property.getName()) || !(property.getValue() instanceof JsonObject)) continue;
            JsonSchemaObject child = new JsonSchemaObject((JsonObject)property.getValue());
            queue.add(child);
            map2.put(property.getName(), child);
        }
        HashMap<String, JsonSchemaObject> hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaReader", "readInnerObject"));
        }
        return hashMap;
    }

    private static MyReader createDefault() {
        return (element, object, queue) -> {
            if (element instanceof JsonObject) {
                JsonSchemaObject schemaObject = new JsonSchemaObject((JsonObject)element);
                queue.add(schemaObject);
                object.setDefault(schemaObject);
            } else if (element instanceof JsonStringLiteral) {
                object.setDefault(StringUtil.unquoteString((String)((JsonStringLiteral)element).getValue()));
            } else if (element instanceof JsonNumberLiteral) {
                object.setDefault(JsonSchemaReader.getNumber((JsonNumberLiteral)element));
            } else if (element instanceof JsonBooleanLiteral) {
                object.setDefault(((JsonBooleanLiteral)element).getValue());
            }
        };
    }

    static {
        JsonSchemaReader.fillMap();
    }

    private static interface MyReader {
        public void read(@NotNull JsonElement var1, @NotNull JsonSchemaObject var2, @NotNull Collection<JsonSchemaObject> var3);
    }
}

