/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/impl/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new JsonSchemaRefReference((JsonValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaRefReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JsonSchemaRefReference
    extends JsonSchemaBaseReference<JsonValue> {
        public JsonSchemaRefReference(JsonValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @NotNull
        public String getCanonicalText() {
            String string = StringUtil.unquoteString((String)super.getCanonicalText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaRefReferenceProvider$JsonSchemaRefReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String normalized;
            String text2 = this.getCanonicalText();
            JsonSchemaService service = JsonSchemaService.Impl.get(((JsonValue)this.getElement()).getProject());
            JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter(text2);
            VirtualFile schemaFile = ((JsonValue)this.getElement()).getContainingFile().getVirtualFile();
            if (splitter.isAbsolute()) {
                assert (splitter.getSchemaId() != null);
                schemaFile = service.findSchemaFileByReference(splitter.getSchemaId(), schemaFile);
                if (schemaFile == null) {
                    return null;
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(normalized = JsonSchemaService.normalizeId(splitter.getRelativePath()))) || StringUtil.split((String)normalized.replace("\\", "/"), (String)"/").size() == 0) {
                return ((JsonValue)this.myElement).getManager().findFile(schemaFile);
            }
            List chain = StringUtil.split((String)normalized.replace("\\", "/"), (String)"/");
            Iterator iterator = chain.iterator();
            boolean canSkip = true;
            while (iterator.hasNext()) {
                String step = (String)iterator.next();
                if (canSkip && "properties".equals(step)) {
                    iterator.remove();
                    canSkip = false;
                    continue;
                }
                canSkip = true;
            }
            JsonSchemaObject schemaObject = service.getSchemaObjectForSchemaFile(schemaFile);
            if (schemaObject == null) {
                return null;
            }
            List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonSchemaVariantsTreeBuilder.buildSteps(StringUtil.join((Collection)chain, (String)"/"));
            return new JsonSchemaResolver(schemaObject, true, steps).findNavigationTarget(true, false);
        }
    }
}

