/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPropertyName2SchemaDefinitionReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaRefReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReferenceContributor
extends PsiReferenceContributor {
    private static final PsiElementPattern.Capture<JsonValue> REF_PATTERN = JsonSchemaReferenceContributor.createPropertyValuePattern("$ref");
    public static final PsiElementPattern.Capture<JsonStringLiteral> PROPERTY_NAME_PATTERN = JsonSchemaReferenceContributor.createPropertyNamePattern();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/jsonSchema/impl/JsonSchemaReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(REF_PATTERN, (PsiReferenceProvider)new JsonSchemaRefReferenceProvider());
        registrar.registerReferenceProvider(PROPERTY_NAME_PATTERN, (PsiReferenceProvider)new JsonPropertyName2SchemaDefinitionReferenceProvider());
    }

    private static PsiElementPattern.Capture<JsonValue> createPropertyValuePattern(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/jsonSchema/impl/JsonSchemaReferenceContributor", "createPropertyValuePattern"));
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonValue.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonValue) {
                    JsonValue value2 = (JsonValue)element;
                    if (!JsonSchemaService.isSchemaFile(value2.getContainingFile())) {
                        return false;
                    }
                    if (value2.getParent() instanceof JsonProperty && ((JsonProperty)value2.getParent()).getValue() == element) {
                        return propertyName.equals(((JsonProperty)value2.getParent()).getName());
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }

    private static PsiElementPattern.Capture<JsonStringLiteral> createPropertyNamePattern() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(JsonStringLiteral.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (element instanceof JsonStringLiteral) {
                    PsiElement parent = ((JsonStringLiteral)element).getParent();
                    return parent instanceof JsonProperty && ((JsonProperty)parent).getNameElement() == element;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));
    }
}

