/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.SmartList;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaTreeNode {
    private boolean myAny;
    private boolean myNothing;
    private int myExcludingGroupNumber = -1;
    @NotNull
    private SchemaResolveState myResolveState = SchemaResolveState.normal;
    @Nullable
    private final JsonSchemaObject mySchema;
    @NotNull
    private final List<JsonSchemaVariantsTreeBuilder.Step> mySteps = new SmartList();
    @NotNull
    private final List<JsonSchemaTreeNode> myChildren = new ArrayList<JsonSchemaTreeNode>();

    public JsonSchemaTreeNode(@Nullable JsonSchemaTreeNode parent, @Nullable JsonSchemaObject schema) {
        assert (schema != null || parent != null);
        this.mySchema = schema;
        if (parent != null && !parent.getSteps().isEmpty()) {
            this.mySteps.addAll(parent.getSteps().subList(1, parent.getSteps().size()));
        }
    }

    public void anyChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myAny = true;
        this.myChildren.add(node);
    }

    public void nothingChild() {
        JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
        node.myNothing = true;
        this.myChildren.add(node);
    }

    public void createChildrenFromOperation(@NotNull JsonSchemaVariantsTreeBuilder.Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "createChildrenFromOperation"));
        }
        if (!SchemaResolveState.normal.equals((Object)operation.myState)) {
            JsonSchemaTreeNode node = new JsonSchemaTreeNode(this, null);
            node.myResolveState = operation.myState;
            this.myChildren.add(node);
            return;
        }
        if (!operation.myAnyOfGroup.isEmpty()) {
            this.myChildren.addAll(this.convertToNodes(operation.myAnyOfGroup));
        }
        if (!operation.myOneOfGroup.isEmpty()) {
            int i2 = 0;
            while (i2 < operation.myOneOfGroup.size()) {
                List<JsonSchemaObject> group = operation.myOneOfGroup.get(i2);
                List<JsonSchemaTreeNode> children2 = this.convertToNodes(group);
                int number = i2++;
                children2.forEach(c -> {
                    c.myExcludingGroupNumber = number;
                });
                this.myChildren.addAll(children2);
            }
        }
    }

    private List<JsonSchemaTreeNode> convertToNodes(List<JsonSchemaObject> children2) {
        return children2.stream().map(s -> new JsonSchemaTreeNode(this, (JsonSchemaObject)s)).collect(Collectors.toList());
    }

    @NotNull
    public SchemaResolveState getResolveState() {
        SchemaResolveState schemaResolveState = this.myResolveState;
        if (schemaResolveState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "getResolveState"));
        }
        return schemaResolveState;
    }

    public boolean isAny() {
        return this.myAny;
    }

    public boolean isNothing() {
        return this.myNothing;
    }

    public void setChild(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "setChild"));
        }
        this.myChildren.add(new JsonSchemaTreeNode(this, schema));
    }

    @Nullable
    public JsonSchemaObject getSchema() {
        return this.mySchema;
    }

    @NotNull
    public List<JsonSchemaVariantsTreeBuilder.Step> getSteps() {
        List<JsonSchemaVariantsTreeBuilder.Step> list2 = this.mySteps;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "getSteps"));
        }
        return list2;
    }

    @NotNull
    public List<JsonSchemaTreeNode> getChildren() {
        List<JsonSchemaTreeNode> list2 = this.myChildren;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "getChildren"));
        }
        return list2;
    }

    public int getExcludingGroupNumber() {
        return this.myExcludingGroupNumber;
    }

    public void setSteps(@NotNull List<JsonSchemaVariantsTreeBuilder.Step> steps) {
        if (steps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonSchemaTreeNode", "setSteps"));
        }
        this.mySteps.clear();
        this.mySteps.addAll(steps);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaTreeNode node = (JsonSchemaTreeNode)o;
        if (this.myAny != node.myAny) {
            return false;
        }
        if (this.myNothing != node.myNothing) {
            return false;
        }
        if (this.myResolveState != node.myResolveState) {
            return false;
        }
        if (this.mySchema != null ? !this.mySchema.equals(node.mySchema) : node.mySchema != null) {
            return false;
        }
        return this.mySteps.equals(node.mySteps);
    }

    public int hashCode() {
        int result2 = this.myAny ? 1 : 0;
        result2 = 31 * result2 + (this.myNothing ? 1 : 0);
        result2 = 31 * result2 + this.myResolveState.hashCode();
        result2 = 31 * result2 + (this.mySchema != null ? this.mySchema.hashCode() : 0);
        result2 = 31 * result2 + this.mySteps.hashCode();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NODE#" + this.hashCode() + "\n");
        sb.append(this.mySteps.stream().map(Object::toString).collect(Collectors.joining("->", "steps: <", ">")));
        sb.append("\n");
        if (this.myExcludingGroupNumber >= 0) {
            sb.append("in excluding group\n");
        }
        if (this.myAny) {
            sb.append("any");
        } else if (this.myNothing) {
            sb.append("nothing");
        } else if (!SchemaResolveState.normal.equals((Object)this.myResolveState)) {
            sb.append(this.myResolveState.name());
        } else {
            assert (this.mySchema != null);
            String name2 = this.mySchema.getSchemaFile().getName();
            sb.append("schema from file: ").append(name2).append("\n");
            if (this.mySchema.getRef() != null) {
                sb.append("$ref: ").append(this.mySchema.getRef()).append("\n");
            } else if (!this.mySchema.getProperties().isEmpty()) {
                sb.append("properties: ");
                sb.append(this.mySchema.getProperties().keySet().stream().collect(Collectors.joining(", "))).append("\n");
            }
            if (!this.myChildren.isEmpty()) {
                sb.append("OR children of NODE#").append(this.hashCode()).append(":\n----------------\n").append(this.myChildren.stream().map(Object::toString).collect(Collectors.joining("\n"))).append("\n=================\n");
            }
        }
        return sb.toString();
    }
}

