/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.adapters;

import com.intellij.json.psi.JsonArray;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.adapters.JsonJsonPropertyAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonJsonArrayAdapter
implements JsonArrayValueAdapter {
    @NotNull
    private final JsonArray myArray;

    public JsonJsonArrayAdapter(@NotNull JsonArray array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/jetbrains/jsonSchema/impl/adapters/JsonJsonArrayAdapter", "<init>"));
        }
        this.myArray = array;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isStringLiteral() {
        return false;
    }

    @Override
    public boolean isNumberLiteral() {
        return false;
    }

    @Override
    public boolean isBooleanLiteral() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getDelegate() {
        JsonArray jsonArray = this.myArray;
        if (jsonArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/adapters/JsonJsonArrayAdapter", "getDelegate"));
        }
        return jsonArray;
    }

    @Override
    @Nullable
    public JsonObjectValueAdapter getAsObject() {
        return null;
    }

    @Override
    @Nullable
    public JsonArrayValueAdapter getAsArray() {
        return this;
    }

    @Override
    @NotNull
    public List<JsonValueAdapter> getElements() {
        List<JsonValueAdapter> list2 = this.myArray.getValueList().stream().filter(e -> e != null).map(e -> JsonJsonPropertyAdapter.createAdapterByType(e)).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/adapters/JsonJsonArrayAdapter", "getElements"));
        }
        return list2;
    }
}

