/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspectionBase
extends BaseInspection {
    public boolean ignoreTestClasses = false;
    public boolean ignoreAnonymousClasses = true;
    public boolean ignoreOnConflicts = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String name2 = element.getName();
        if (infos.length > 1) {
            if (Boolean.TRUE.equals(infos[1])) {
                String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.extending", name2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor.anonymous.implementing", name2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", name2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.test.option", new Object[0]), "ignoreTestClasses");
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.anonymous.option", new Object[0]), "ignoreAnonymousClasses");
        panel2.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.on.conflicts", new Object[0]), "ignoreOnConflicts");
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticMethodOnlyUsedInOneClassVisitor();
    }

    static boolean areReferenceTargetsAccessible(PsiElement elementToCheck, PsiElement place) {
        AccessibleVisitor visitor = new AccessibleVisitor(elementToCheck, place);
        elementToCheck.accept((PsiElementVisitor)visitor);
        return visitor.isAccessible();
    }

    private static class AccessibleVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myElementToCheck;
        private final PsiElement myPlace;
        private boolean myAccessible = true;

        public AccessibleVisitor(PsiElement elementToCheck, PsiElement place) {
            this.myElementToCheck = elementToCheck;
            this.myPlace = place;
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            if (!this.myAccessible) {
                return;
            }
            super.visitCallExpression(callExpression);
            PsiMethod method = callExpression.resolveMethod();
            if (callExpression instanceof PsiNewExpression && method == null) {
                PsiNewExpression newExpression = (PsiNewExpression)callExpression;
                PsiJavaCodeReferenceElement reference = newExpression.getClassReference();
                if (reference != null) {
                    this.checkElement(reference.resolve());
                }
            } else {
                this.checkElement((PsiElement)method);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (!this.myAccessible) {
                return;
            }
            super.visitReferenceExpression(expression2);
            this.checkElement(expression2.resolve());
        }

        private void checkElement(PsiElement element) {
            if (!(element instanceof PsiMember)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myElementToCheck, (PsiElement)element, (boolean)false)) {
                return;
            }
            this.myAccessible = PsiUtil.isAccessible((PsiMember)((PsiMember)element), (PsiElement)this.myPlace, null);
        }

        public boolean isAccessible() {
            return this.myAccessible;
        }
    }

    private class StaticMethodOnlyUsedInOneClassVisitor
    extends BaseInspectionVisitor {
        private StaticMethodOnlyUsedInOneClassVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("static")) {
                return;
            }
            if (method.hasModifierProperty("private")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            UsageProcessor usageProcessor = new UsageProcessor();
            PsiClass usageClass = usageProcessor.getUsageClass(method);
            if (usageClass == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (usageClass.equals(containingClass)) {
                return;
            }
            if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreOnConflicts && (usageClass.findMethodsBySignature(method, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspectionBase.areReferenceTargetsAccessible((PsiElement)method, (PsiElement)usageClass))) {
                return;
            }
            if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreTestClasses && TestUtils.isInTestCode((PsiElement)usageClass)) {
                return;
            }
            if (usageClass instanceof PsiAnonymousClass) {
                if (StaticMethodOnlyUsedInOneClassInspectionBase.this.ignoreAnonymousClasses) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)usageClass, (boolean)true)) {
                    return;
                }
                PsiClass[] interfaces = usageClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method, superClass, Boolean.FALSE);
                } else {
                    PsiClass superClass = usageClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method, superClass, Boolean.TRUE);
                }
            } else {
                this.registerMethodError(method, usageClass);
            }
        }
    }

    private static class UsageProcessor
    implements Processor<PsiReference> {
        private final AtomicReference<PsiClass> foundClass = new AtomicReference();

        private UsageProcessor() {
        }

        public boolean process(PsiReference reference) {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiClass usageClass = ClassUtils.getContainingClass(element);
            if (usageClass == null) {
                return true;
            }
            if (this.foundClass.compareAndSet(null, usageClass)) {
                return true;
            }
            PsiClass aClass = this.foundClass.get();
            PsiManager manager = usageClass.getManager();
            return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)usageClass);
        }

        @Nullable
        public PsiClass getUsageClass(PsiMethod method) {
            if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method, true)) {
                return null;
            }
            ProgressManager.getInstance().runProcess(() -> {
                Query query = MethodReferencesSearch.search((PsiMethod)method);
                if (!query.forEach((Processor)this)) {
                    this.foundClass.set(null);
                }
            }, null);
            return this.foundClass.get();
        }
    }
}

