/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = false;
    static final Set<IElementType> bitwiseTokens = new HashSet<IElementType>(6);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)infos[0];
        String replacementExpression = this.calculateReplacementExpression(polyadicExpression);
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", replacementExpression);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression2) {
        IElementType tokenType = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        PsiExpression previousOperand = null;
        int length = operands2.length;
        for (int i2 = 0; i2 < length; ++i2) {
            PsiExpression operand2 = operands2[i2];
            if (this.isZero(operand2)) {
                if (tokenType.equals(JavaTokenType.AND) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand == null) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)operands2[0], (PsiElement)operands2[length - 1], PsiType.LONG.equals((Object)expression2.getType()) ? "0L" : "0");
                }
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.XOR) || (tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT)) && previousOperand != null) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)(i2 == length - 1 ? expression2.getTokenBeforeOperand(operand2) : operand2));
                }
            } else if (this.isAllOnes(operand2)) {
                if (tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)(i2 == length - 1 ? expression2.getTokenBeforeOperand(operand2) : operand2));
                }
                if (tokenType.equals(JavaTokenType.OR)) {
                    return operand2.getText();
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    if (previousOperand != null) {
                        return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, "~" + previousOperand.getText());
                    }
                    PsiExpression nextOperand = operands2[i2 + 1];
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)operand2, (PsiElement)nextOperand, "~" + nextOperand.getText());
                }
            } else if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousOperand, operand2)) {
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, operand2.getText());
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    return PointlessBitwiseExpressionInspection.getText(expression2, (PsiElement)previousOperand, (PsiElement)operand2, PsiType.LONG.equals((Object)expression2.getType()) ? "0L" : "0");
                }
            }
            previousOperand = operand2;
        }
        return "";
    }

    public static String getText(PsiPolyadicExpression expression2, PsiElement fromTarget, PsiElement untilTarget, @NotNull @NonNls String replacement) {
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection", "getText"));
        }
        StringBuilder result2 = new StringBuilder();
        boolean stop2 = false;
        for (PsiElement child : expression2.getChildren()) {
            if (child == fromTarget) {
                stop2 = true;
                result2.append(replacement);
                continue;
            }
            if (child == untilTarget) {
                stop2 = false;
                continue;
            }
            if (child instanceof PsiComment || !stop2) {
                result2.append(child.getText());
                continue;
            }
            if (!(child instanceof PsiJavaToken) || untilTarget != null) continue;
            stop2 = false;
        }
        return result2.toString();
    }

    private static String getText(PsiPolyadicExpression expression2, PsiElement exclude) {
        return PointlessBitwiseExpressionInspection.getText(expression2, exclude, null, "").trim();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private boolean isZero(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression2 instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression2);
    }

    private boolean isAllOnes(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression2 instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        Object value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)expressionType);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Integer && (Integer)value2 == -1) {
            return true;
        }
        if (value2 instanceof Long && (Long)value2 == -1L) {
            return true;
        }
        if (value2 instanceof Short && (Short)value2 == -1) {
            return true;
        }
        if (value2 instanceof Character && ((Character)value2).charValue() == '\uffff') {
            return true;
        }
        return value2 instanceof Byte && (Byte)value2 == -1;
    }

    static {
        bitwiseTokens.add(JavaTokenType.AND);
        bitwiseTokens.add(JavaTokenType.OR);
        bitwiseTokens.add(JavaTokenType.XOR);
        bitwiseTokens.add(JavaTokenType.LTLT);
        bitwiseTokens.add(JavaTokenType.GTGT);
        bitwiseTokens.add(JavaTokenType.GTGTGT);
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            PsiExpression[] operands2;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor", "visitPolyadicExpression"));
            }
            super.visitPolyadicExpression(expression2);
            IElementType sign = expression2.getOperationTokenType();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)expression2)) {
                return;
            }
            for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
                if (operand2 == null) {
                    return;
                }
                PsiType type2 = operand2.getType();
                if (type2 != null && !type2.equals(PsiType.BOOLEAN) && !type2.equalsToText("java.lang.Boolean")) continue;
                return;
            }
            boolean isPointless = sign.equals(JavaTokenType.AND) || sign.equals(JavaTokenType.OR) || sign.equals(JavaTokenType.XOR) ? this.booleanExpressionIsPointless(operands2) : (sign.equals(JavaTokenType.LTLT) || sign.equals(JavaTokenType.GTGT) || sign.equals(JavaTokenType.GTGTGT) ? this.shiftExpressionIsPointless(operands2) : false);
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean booleanExpressionIsPointless(PsiExpression[] operands2) {
            PsiExpression previousExpression = null;
            for (PsiExpression operand2 : operands2) {
                if (PointlessBitwiseExpressionInspection.this.isZero(operand2) || PointlessBitwiseExpressionInspection.this.isAllOnes(operand2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousExpression, operand2) && !SideEffectChecker.mayHaveSideEffects(operand2)) {
                    return true;
                }
                previousExpression = operand2;
            }
            return false;
        }

        private boolean shiftExpressionIsPointless(PsiExpression[] operands2) {
            for (PsiExpression operand2 : operands2) {
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand2)) continue;
                return true;
            }
            return false;
        }
    }

    private class PointlessBitwiseFix
    extends InspectionGadgetsFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)descriptor.getPsiElement();
            String newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression2);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression);
        }
    }
}

