/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AssertWithSideEffectsInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> resultSetSideEffectMethods = ContainerUtil.newHashSet((Object[])new String[]{"next", "first", "last", "absolute", "relative", "previous"});

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/AssertWithSideEffectsInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assert.with.side.effects.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/AssertWithSideEffectsInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertWithSideEffectsVisitor();
    }

    private static boolean methodHasSideEffects(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return false;
        }
        MethodSideEffectVisitor visitor = new MethodSideEffectVisitor();
        body2.accept((PsiElementVisitor)visitor);
        return visitor.hasSideEffects();
    }

    private static class MethodSideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private MethodSideEffectVisitor() {
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            this.checkExpression(expression2.getLExpression());
            super.visitAssignmentExpression(expression2);
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression2.getOperand());
            }
            super.visitPrefixExpression(expression2);
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.checkExpression(expression2.getOperand());
            }
            super.visitPostfixExpression(expression2);
        }

        private void checkExpression(PsiExpression operand2) {
            if (!(operand2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
            PsiElement target2 = referenceExpression.resolve();
            if (target2 instanceof PsiField) {
                this.hasSideEffects = true;
            }
        }

        private boolean hasSideEffects() {
            return this.hasSideEffects;
        }
    }

    private static class SideEffectVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean hasSideEffects;

        private SideEffectVisitor() {
        }

        boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.hasSideEffects = true;
        }

        public void visitElement(PsiElement element) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.hasSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            if (AssertWithSideEffectsInspection.methodHasSideEffects(method)) {
                this.hasSideEffects = true;
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.sql.ResultSet".equals(containingClass.getQualifiedName())) {
                return;
            }
            String methodName = method.getName();
            if (resultSetSideEffectMethods.contains(methodName)) {
                this.hasSideEffects = true;
            }
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                this.hasSideEffects = true;
            }
        }
    }

    private static class AssertWithSideEffectsVisitor
    extends BaseInspectionVisitor {
        private AssertWithSideEffectsVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement statement2) {
            super.visitAssertStatement(statement2);
            PsiExpression condition2 = statement2.getAssertCondition();
            if (condition2 == null) {
                return;
            }
            SideEffectVisitor visitor = new SideEffectVisitor();
            condition2.accept((PsiElementVisitor)visitor);
            if (!visitor.hasSideEffects()) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }
    }
}

