/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class EmptyStatementBodyInspection
extends BaseInspection {
    public boolean m_reportEmptyBlocks = true;
    public boolean commentsAreContent = false;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", "m_reportEmptyBlocks").setAttribute("value", String.valueOf(this.m_reportEmptyBlocks)));
        if (this.commentsAreContent) {
            node.addContent(new Element("option").setAttribute("name", "commentsAreContent").setAttribute("value", "true"));
        }
    }

    @NotNull
    public String getID() {
        if ("StatementWithEmptyBody" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "getID"));
        }
        return "StatementWithEmptyBody";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.with.empty.body.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyStatementBodyInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("statement.with.empty.body.include.option", new Object[0]), "m_reportEmptyBlocks");
        panel2.addCheckbox(InspectionGadgetsBundle.message("empty.catch.block.comments.option", new Object[0]), "commentsAreContent");
        return panel2;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyStatementVisitor();
    }

    private class EmptyStatementVisitor
    extends BaseInspectionVisitor {
        private EmptyStatementVisitor() {
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitDoWhileStatement"));
            }
            super.visitDoWhileStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitForeachStatement"));
            }
            super.visitForeachStatement(statement2);
            this.checkLoopStatement((PsiLoopStatement)statement2);
        }

        private void checkLoopStatement(PsiLoopStatement statement2) {
            PsiStatement body2 = statement2.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/EmptyStatementBodyInspection$EmptyStatementVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement2);
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch != null && this.isEmpty((PsiElement)thenBranch)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
                return;
            }
            PsiStatement elseBranch = statement2.getElseBranch();
            if (elseBranch != null && this.isEmpty((PsiElement)elseBranch)) {
                PsiKeyword elseToken = statement2.getElseElement();
                if (elseToken == null) {
                    return;
                }
                this.registerError((PsiElement)elseToken, new Object[0]);
            }
        }

        public void visitSwitchStatement(PsiSwitchStatement statement2) {
            super.visitSwitchStatement(statement2);
            PsiCodeBlock body2 = statement2.getBody();
            if (body2 == null || !this.isEmpty((PsiElement)body2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, new Object[0]);
        }

        private boolean isEmpty(PsiElement element) {
            if (!EmptyStatementBodyInspection.this.commentsAreContent && element instanceof PsiComment) {
                return true;
            }
            if (element instanceof PsiEmptyStatement) {
                return !EmptyStatementBodyInspection.this.commentsAreContent || PsiTreeUtil.getChildOfType((PsiElement)element, PsiComment.class) == null && !(PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class}) instanceof PsiComment);
            }
            if (element instanceof PsiWhiteSpace) {
                return true;
            }
            if (element instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)element;
                return this.isEmpty((PsiElement)block.getCodeBlock());
            }
            if (EmptyStatementBodyInspection.this.m_reportEmptyBlocks && element instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)element;
                PsiElement[] children2 = codeBlock.getChildren();
                if (children2.length == 2) {
                    return true;
                }
                for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                    PsiElement child = children2[i2];
                    if (this.isEmpty(child)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

