/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreResultOfCallInspectionBase
extends BaseInspection {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterCount(1);
    private static final CallMatcher COLLECTOR_TO_COLLECTION = CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1);
    public boolean m_reportAllNonLibraryCalls = false;
    protected final MethodMatcher myMethodMatcher = new MethodMatcher(true, "callCheckString").add("java.io.File", ".*").add("java.io.InputStream", "read|skip|available|markSupported").add("java.io.Reader", "read|skip|ready|markSupported").add("java.lang.Boolean", ".*").add("java.lang.Byte", ".*").add("java.lang.Character", ".*").add("java.lang.Double", ".*").add("java.lang.Float", ".*").add("java.lang.Integer", ".*").add("java.lang.Long", ".*").add("java.lang.Math", ".*").add("java.lang.Object", "equals|hashCode|toString").add("java.lang.Short", ".*").add("java.lang.StrictMath", ".*").add("java.lang.String", ".*").add("java.math.BigInteger", ".*").add("java.math.BigDecimal", ".*").add("java.net.InetAddress", ".*").add("java.net.URI", ".*").add("java.util.List", "of").add("java.util.Set", "of").add("java.util.Map", "of|ofEntries|entry").add("java.util.Collections", "unmodifiable.*|singleton.*|checked.*|min|max|stream").add("java.util.UUID", ".*").add("java.util.regex.Matcher", "pattern|toMatchResult|start|end|group|groupCount|matches|find|lookingAt|quoteReplacement|replaceAll|replaceFirst|regionStart|regionEnd|hasTransparentBounds|hasAnchoringBounds|hitEnd|requireEnd").add("java.util.regex.Pattern", ".*").add("java.util.stream.BaseStream", ".*").finishDefault();

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getID"));
        }
        return "ResultOfMethodCallIgnored";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "buildErrorString"));
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase", "writeSettings"));
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement resolve2;
            if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)) && (resolve2 = expression2.resolve()) instanceof PsiMethod) {
                this.visitCalledExpression((PsiExpression)expression2, (PsiMethod)resolve2, null);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)))) {
                PsiMethod method = expression2.resolveMethod();
                if (method == null || method.isConstructor()) {
                    return;
                }
                this.visitCalledExpression((PsiExpression)expression2, method, parent);
            }
        }

        private void visitCalledExpression(PsiExpression call, PsiMethod method, @Nullable PsiElement errorContainer) {
            PsiElement owner2;
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (errorContainer != null && PsiUtilCore.hasErrorElementChild((PsiElement)errorContainer)) {
                return;
            }
            if (PropertyUtil.isSimpleGetter((PsiMethod)method)) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            if (IgnoreResultOfCallInspectionBase.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            if (this.isPureMethod(method)) {
                this.registerMethodCallOrRefError(call, aClass);
                return;
            }
            PsiAnnotation annotation = this.findAnnotationInTree((PsiElement)method, null, Collections.singleton("javax.annotation.CheckReturnValue"));
            if (annotation != null && this.findAnnotationInTree((PsiElement)method, owner2 = (PsiElement)annotation.getOwner(), Collections.singleton("com.google.errorprone.annotations.CanIgnoreReturnValue")) != null) {
                return;
            }
            if (!IgnoreResultOfCallInspectionBase.this.myMethodMatcher.matches(method) && annotation == null) {
                return;
            }
            if (this.isHardcodedException(call)) {
                return;
            }
            this.registerMethodCallOrRefError(call, aClass);
        }

        private boolean isHardcodedException(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (STREAM_COLLECT.test(call)) {
                PsiExpression body2;
                PsiLambdaExpression lambda2;
                PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                if (COLLECTOR_TO_COLLECTION.test(collector) && (lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)collector.getArgumentList().getExpressions()[0]), PsiLambdaExpression.class)) != null && (body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()))) instanceof PsiReferenceExpression && ((PsiReferenceExpression)body2).resolve() instanceof PsiVariable) {
                    return true;
                }
            }
            return false;
        }

        private boolean isPureMethod(PsiMethod method) {
            PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method);
            if (anno == null) {
                return false;
            }
            boolean honorInferred = Registry.is((String)"ide.ignore.call.result.inspection.honor.inferred.pure");
            if (!honorInferred && AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
                return false;
            }
            return Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure")) && !SideEffectChecker.mayHaveExceptionalSideEffect(method);
        }

        private void registerMethodCallOrRefError(PsiExpression call, PsiClass aClass) {
            if (call instanceof PsiMethodCallExpression) {
                this.registerMethodCallError((PsiMethodCallExpression)call, aClass);
            } else if (call instanceof PsiMethodReferenceExpression) {
                this.registerError((PsiElement)ObjectUtils.notNull((Object)((PsiMethodReferenceExpression)call).getReferenceNameElement(), (Object)call), aClass);
            }
        }

        @Nullable
        private PsiAnnotation findAnnotationInTree(PsiElement element, @Nullable PsiElement stop2, @NotNull Set<String> fqAnnotationNames) {
            if (fqAnnotationNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqAnnotationNames", "com/siyeh/ig/bugs/IgnoreResultOfCallInspectionBase$IgnoreResultOfCallVisitor", "findAnnotationInTree"));
            }
            while (element != null) {
                PsiModifierListOwner modifierListOwner;
                PsiAnnotation annotation;
                if (element == stop2) {
                    return null;
                }
                if (element instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)(modifierListOwner = (PsiModifierListOwner)element), fqAnnotationNames)) != null) {
                    return annotation;
                }
                if (element instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)element;
                    String packageName = classOwner.getPackageName();
                    PsiPackage aPackage = JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(packageName);
                    if (aPackage == null) {
                        return null;
                    }
                    PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, fqAnnotationNames);
                    if (annotation2 != null) {
                        VirtualFile currentClassRoot;
                        ProjectFileIndex projectFileIndex;
                        VirtualFile annotationClassRoot;
                        VirtualFile annotationFile = PsiUtilCore.getVirtualFile((PsiElement)annotation2);
                        VirtualFile currentFile = classOwner.getVirtualFile();
                        if (annotationFile != null && currentFile != null && !Objects.equals(annotationClassRoot = (projectFileIndex = ProjectFileIndex.getInstance((Project)element.getProject())).getClassRootForFile(annotationFile), currentClassRoot = projectFileIndex.getClassRootForFile(currentFile))) {
                            return null;
                        }
                    }
                    return annotation2;
                }
                element = element.getContext();
            }
            return null;
        }
    }
}

