/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class MalformedRegexInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.regular.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedRegexInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor1", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedRegexInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("malformed.regular.expression.problem.descriptor2", infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MalformedRegexInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedRegexVisitor();
    }

    private static class MalformedRegexVisitor
    extends BaseInspectionVisitor {
        private MalformedRegexVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/siyeh/ig/bugs/MalformedRegexInspection$MalformedRegexVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(methodCallExpression);
            if (!MethodCallUtils.isCallToRegexMethod(methodCallExpression)) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            if (!ExpressionUtils.hasStringType(firstArgument)) {
                return;
            }
            String value2 = (String)ExpressionUtils.computeConstantExpression(firstArgument);
            if (value2 == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if ("compile".equals(methodExpression.getReferenceName()) && arguments.length == 2) {
                PsiExpression secondArgument = arguments[1];
                Object flags = ExpressionUtils.computeConstantExpression(secondArgument);
                if (flags instanceof Integer) {
                    try {
                        Pattern.compile(value2, (Integer)flags);
                    }
                    catch (PatternSyntaxException e) {
                        this.registerError((PsiElement)firstArgument, e.getDescription());
                    }
                    catch (NullPointerException e) {
                        this.registerError((PsiElement)firstArgument, new Object[0]);
                    }
                }
                return;
            }
            try {
                Pattern.compile(value2);
            }
            catch (PatternSyntaxException e) {
                this.registerError((PsiElement)firstArgument, e.getDescription());
            }
            catch (NullPointerException e) {
                this.registerError((PsiElement)firstArgument, new Object[0]);
            }
        }
    }
}

