/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

class NonFinalFieldsVisitor
extends BaseInspectionVisitor {
    NonFinalFieldsVisitor() {
    }

    void checkUsedNonFinalFields(PsiMethod method) {
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NonFinalFieldsVisitor$1", "visitReferenceExpression"));
                }
                super.visitReferenceExpression(expression2);
                PsiElement element = expression2.resolve();
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field = (PsiField)element;
                if (field.hasModifierProperty("final")) {
                    return;
                }
                NonFinalFieldsVisitor.this.registerError((PsiElement)expression2, new Object[]{field});
            }
        });
    }
}

