/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SubtractionInCompareToInspectionBase
extends BaseInspection {
    protected final MethodMatcher methodMatcher = new MethodMatcher().add("java.util.Collection", "size").add("java.util.Map", "size").add("java.lang.String", "length").add("java.lang.AbstractStringBuilder", "length").finishDefault();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/SubtractionInCompareToInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        this.methodMatcher.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/bugs/SubtractionInCompareToInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        this.methodMatcher.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SubtractionInCompareToInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("subtraction.in.compareto.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SubtractionInCompareToInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SubtractionInCompareToVisitor();
    }

    private class SubtractionInCompareToVisitor
    extends BaseInspectionVisitor {
        private SubtractionInCompareToVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiClass functionalInterface;
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.MINUS) || this.isSafeSubtraction(expression2)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (lambdaExpression != null && (functionalInterface = PsiUtil.resolveClassInType((PsiType)lambdaExpression.getFunctionalInterfaceType())) != null && "java.util.Comparator".equals(functionalInterface.getQualifiedName())) {
                this.registerError((PsiElement)expression2, new Object[0]);
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (!MethodUtils.isCompareTo(method) && !MethodUtils.isComparatorCompare(method)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private boolean isSafeSubtraction(PsiPolyadicExpression polyadicExpression) {
            PsiType type2 = polyadicExpression.getType();
            if (!PsiType.INT.equals((Object)type2)) {
                return false;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            if (operands2.length != 2) {
                return false;
            }
            PsiExpression lhs = operands2[0];
            PsiExpression rhs = operands2[1];
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null) {
                return false;
            }
            if ((PsiType.BYTE.equals((Object)lhsType) || PsiType.SHORT.equals((Object)lhsType) || PsiType.CHAR.equals((Object)lhsType)) && (PsiType.BYTE.equals((Object)rhsType) || PsiType.SHORT.equals((Object)rhsType) || PsiType.CHAR.equals((Object)rhsType))) {
                return true;
            }
            return this.isSafeOperand(lhs) && this.isSafeOperand(rhs);
        }

        private boolean isSafeOperand(PsiExpression operand2) {
            if ((operand2 = ParenthesesUtils.stripParentheses(operand2)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
                return SubtractionInCompareToInspectionBase.this.methodMatcher.matches((PsiCall)methodCallExpression);
            }
            if (operand2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
                String name2 = referenceExpression.getReferenceName();
                if (!"length".equals(name2)) {
                    return false;
                }
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(referenceExpression.getQualifierExpression());
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiType type2 = qualifier.getType();
                return type2 instanceof PsiArrayType;
            }
            return false;
        }
    }
}

