/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousToArrayCallInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.to.array.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String string = InspectionGadgetsBundle.message("suspicious.to.array.call.problem.descriptor", type2.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousToArrayCallVisitor();
    }

    private static class SuspiciousToArrayCallVisitor
    extends BaseInspectionVisitor {
        private SuspiciousToArrayCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            PsiType type2 = qualifierExpression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection")) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            this.checkCollectionAndArrayTypes(classType, argument, expression2);
        }

        private void checkCollectionAndArrayTypes(@NotNull PsiClassType collectionType, @NotNull PsiExpression argument, @NotNull PsiMethodCallExpression expression2) {
            if (collectionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionType", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor", "checkCollectionAndArrayTypes"));
            }
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor", "checkCollectionAndArrayTypes"));
            }
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor", "checkCollectionAndArrayTypes"));
            }
            PsiType argumentType = argument.getType();
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)argumentType;
            PsiType componentType = arrayType.getComponentType();
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement castTypeElement = castExpression.getCastType();
                if (castTypeElement == null) {
                    return;
                }
                PsiType castType = castTypeElement.getType();
                if (castType.equals(arrayType) || !(castType instanceof PsiArrayType)) {
                    return;
                }
                PsiArrayType castArrayType = (PsiArrayType)castType;
                this.registerError((PsiElement)argument, castArrayType.getComponentType());
            } else {
                PsiClassType classType;
                PsiClass aClass;
                if (!collectionType.hasParameters()) {
                    return;
                }
                PsiType[] parameters2 = collectionType.getParameters();
                if (parameters2.length != 1) {
                    return;
                }
                PsiType parameter = parameters2[0];
                if (componentType.isAssignableFrom(parameter)) {
                    return;
                }
                if (parameter instanceof PsiClassType && (aClass = (classType = (PsiClassType)parameter).resolve()) instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                    PsiReferenceList extendsList = typeParameter.getExtendsList();
                    PsiClassType[] types = extendsList.getReferencedTypes();
                    if (types.length == 0) {
                        this.registerError((PsiElement)argument, TypeUtils.getObjectType((PsiElement)argument));
                    } else if (types.length == 1) {
                        this.registerError((PsiElement)argument, types[0]);
                    }
                    return;
                }
                this.registerError((PsiElement)argument, parameter);
            }
        }
    }
}

