/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;

public class CallMapper<T> {
    private Map<String, List<Function<PsiMethodCallExpression, T>>> myMap = new HashMap<String, List<Function<PsiMethodCallExpression, T>>>();

    public CallMapper() {
    }

    public CallMapper(CallHandler<T> ... handlers) {
        for (CallHandler<T> handler2 : handlers) {
            this.register(handler2);
        }
    }

    public CallMapper<T> register(CallHandler<T> handler2) {
        handler2.matcher().names().forEach(name2 -> this.myMap.computeIfAbsent((String)name2, k -> new ArrayList()).add(handler2));
        return this;
    }

    public CallMapper<T> register(CallMatcher matcher, Function<PsiMethodCallExpression, T> handler2) {
        return this.register(CallHandler.of(matcher, handler2));
    }

    public CallMapper<T> register(CallMatcher matcher, T value2) {
        return this.register(CallHandler.of(matcher, call -> value2));
    }

    public CallMapper<T> registerAll(List<CallHandler<T>> handlers) {
        handlers.forEach(this::register);
        return this;
    }

    public T mapFirst(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<Function<PsiMethodCallExpression, T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return null;
        }
        for (Function<PsiMethodCallExpression, PsiMethodCallExpression> function : functions) {
            T t = function.apply(call);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public Stream<T> mapAll(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        List<Function<PsiMethodCallExpression, T>> functions = this.myMap.get(call.getMethodExpression().getReferenceName());
        if (functions == null) {
            return StreamEx.empty();
        }
        return StreamEx.of(functions).map(fn -> fn.apply(call)).nonNull();
    }
}

