/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantIfStatementFix();
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 == null) {
                return;
            }
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (BoolUtils.isTrue(condition2) || BoolUtils.isFalse(condition2)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends InspectionGadgetsFix {
        private ConstantIfStatementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConstantIfStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)ifKeyword.getParent();
            assert (statement2 != null);
            PsiStatement thenBranch = statement2.getThenBranch();
            PsiStatement elseBranch = statement2.getElseBranch();
            PsiExpression condition2 = statement2.getCondition();
            if (BoolUtils.isFalse(condition2)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement2);
                } else {
                    ConstantIfStatementFix.deleteElement((PsiElement)statement2);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement2);
            }
        }

        private static void replaceStatementWithUnwrapping(PsiStatement branch, PsiIfStatement statement2) throws IncorrectOperationException {
            if (branch instanceof PsiBlockStatement && !(statement2.getParent() instanceof PsiIfStatement)) {
                PsiCodeBlock parentBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)branch, PsiCodeBlock.class);
                if (parentBlock == null) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement((PsiStatement)statement2, elseText);
                    return;
                }
                PsiCodeBlock block = ((PsiBlockStatement)branch).getCodeBlock();
                boolean hasConflicts = DeclarationSearchUtils.containsConflictingDeclarations(block, parentBlock);
                if (hasConflicts) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement((PsiStatement)statement2, elseText);
                } else {
                    PsiElement containingElement = statement2.getParent();
                    PsiStatement[] statements = block.getStatements();
                    if (statements.length > 0) {
                        assert (containingElement != null);
                        PsiJavaToken lBrace = block.getLBrace();
                        PsiJavaToken rBrace = block.getRBrace();
                        PsiElement added = null;
                        if (lBrace != null && rBrace != null) {
                            PsiElement firstNonBrace = lBrace.getNextSibling();
                            PsiElement lastNonBrace = rBrace.getPrevSibling();
                            if (firstNonBrace != null && lastNonBrace != null) {
                                added = containingElement.addRangeBefore(firstNonBrace, lastNonBrace, (PsiElement)statement2);
                            }
                        }
                        if (added == null) {
                            added = containingElement.addRangeBefore((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)statement2);
                        }
                        Project project2 = statement2.getProject();
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                        codeStyleManager.reformat(added);
                    }
                    statement2.delete();
                }
            } else {
                String elseText = branch.getText();
                PsiReplacementUtil.replaceStatement((PsiStatement)statement2, elseText);
            }
        }
    }
}

