/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegatedConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.conditional.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedConditionalExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalExpressionVisitor();
    }

    private static class NegatedConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalExpressionVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!JavaTokenType.EXCL.equals(expression2.getOperationTokenType())) {
                return;
            }
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(expression2.getOperand());
            if (!(operand2 instanceof PsiConditionalExpression)) {
                return;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), new Object[0]);
        }
    }

    private static class NegatedConditionalExpressionFix
    extends InspectionGadgetsFix {
        private NegatedConditionalExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.conditional.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalExpressionInspection$NegatedConditionalExpressionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            if (!(operand2 instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)operand2;
            StringBuilder newExpression = new StringBuilder();
            PsiExpression condition2 = conditionalExpression.getCondition();
            newExpression.append(condition2.getText()).append('?');
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            if (thenExpression2 != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(thenExpression2));
            }
            newExpression.append(':');
            PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
            if (elseExpression2 != null) {
                newExpression.append(BoolUtils.getNegatedExpressionText(elseExpression2));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, newExpression.toString());
        }
    }
}

